-- GAA OptiTrace v10.1 — Tracciato su strade reali
-- 1266 punti campionati ogni ~250m, quote Google Elevation API
-- Generato: 2026-02-13

DROP TABLE IF EXISTS ot_snapshots;
DROP TABLE IF EXISTS ot_trincee;
DROP TABLE IF EXISTS ot_obstacles;
DROP TABLE IF EXISTS ot_waypoints;
DROP TABLE IF EXISTS ot_settings;

CREATE TABLE ot_waypoints (
    id INT AUTO_INCREMENT PRIMARY KEY,
    idx INT NOT NULL, lat DOUBLE NOT NULL, lon DOUBLE NOT NULL,
    elev_kml DOUBLE DEFAULT 0, elev_google DOUBLE DEFAULT 0,
    resolution DOUBLE DEFAULT 0, km DOUBLE DEFAULT 0,
    piez DOUBLE DEFAULT 0, margine DOUBLE DEFAULT 0,
    pressione_bar DOUBLE DEFAULT 0, classe_pn VARCHAR(10) DEFAULT 'PN16',
    tipo VARCHAR(30) DEFAULT 'condotta', note TEXT,
    modified TINYINT DEFAULT 0, INDEX(km), INDEX(tipo)
) ENGINE=InnoDB CHARSET=utf8mb4;

CREATE TABLE ot_obstacles (
    id INT AUTO_INCREMENT PRIMARY KEY, tipo VARCHAR(30),
    km DOUBLE, lat DOUBLE, lon DOUBLE, descrizione TEXT, distanza_m DOUBLE DEFAULT 0,
    INDEX(km)
) ENGINE=InnoDB CHARSET=utf8mb4;

CREATE TABLE ot_trincee (
    id INT AUTO_INCREMENT PRIMARY KEY,
    start_km DOUBLE, end_km DOUBLE, length_km DOUBLE,
    max_depth DOUBLE, tipo VARCHAR(20) DEFAULT 'trincea'
) ENGINE=InnoDB CHARSET=utf8mb4;

CREATE TABLE ot_settings (
    `key` VARCHAR(100) PRIMARY KEY, `value` TEXT NOT NULL
) ENGINE=InnoDB CHARSET=utf8mb4;

CREATE TABLE ot_snapshots (
    id INT AUTO_INCREMENT PRIMARY KEY, nome VARCHAR(200),
    data_json LONGTEXT, note TEXT, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB CHARSET=utf8mb4;

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(0,42.270050,13.795570,0,332.19,0.0,0.0000,340.00,7.81,0.77,'PN16','presa','Opera di presa - Sorgenti Tirino'),
(1,42.268190,13.796350,0,333.95,0.0,0.2166,339.94,5.99,0.59,'PN16','condotta',''),
(2,42.266800,13.799650,0,337.64,0.0,0.5290,339.85,2.21,0.22,'PN16','condotta',''),
(3,42.265440,13.802160,0,349.65,0.0,0.7850,339.78,-9.87,0.00,'PN16','galleria','Galleria breve (deficit 10m)'),
(4,42.263120,13.803720,0,359.46,0.0,1.0731,339.70,-19.76,0.00,'PN16','galleria','Galleria breve (deficit 20m)'),
(5,42.260950,13.804900,0,370.69,0.0,1.3332,339.63,-31.06,0.00,'PN16','galleria','Galleria breve (deficit 31m)'),
(6,42.258610,13.806160,0,376.50,0.0,1.6133,339.55,-36.95,0.00,'PN16','galleria','Galleria breve (deficit 37m)'),
(7,42.256440,13.807330,0,378.26,0.0,1.8731,339.48,-38.79,0.00,'PN16','galleria','Galleria breve (deficit 39m)'),
(8,42.254280,13.808510,0,377.61,0.0,2.1322,339.40,-38.20,0.00,'PN16','galleria','Galleria breve (deficit 38m)'),
(9,42.252350,13.809600,0,366.28,0.0,2.3648,339.34,-26.94,0.00,'PN16','galleria','Galleria breve (deficit 27m)'),
(10,42.250310,13.811370,0,358.97,0.0,2.6344,339.26,-19.71,0.00,'PN16','galleria','Galleria breve (deficit 20m)'),
(11,42.248360,13.813050,0,351.46,0.0,2.8916,339.19,-12.27,0.00,'PN16','galleria','Galleria breve (deficit 12m)'),
(12,42.246390,13.814550,0,344.46,0.0,3.1430,339.12,-5.34,0.00,'PN16','galleria','Galleria breve (deficit 5m)'),
(13,42.244090,13.814920,0,337.56,0.0,3.4006,339.05,1.49,0.15,'PN16','condotta',''),
(14,42.241810,13.814710,0,320.98,0.0,3.6547,338.98,18.00,1.76,'PN16','condotta',''),
(15,42.239770,13.813900,0,321.56,0.0,3.8911,338.91,17.35,1.70,'PN16','condotta',''),
(16,42.241740,13.812510,0,325.75,0.0,4.1383,338.84,13.09,1.28,'PN16','condotta',''),
(17,42.242720,13.809780,0,323.98,0.0,4.3880,338.77,14.79,1.45,'PN16','condotta',''),
(18,42.244320,13.807620,0,327.37,0.0,4.6395,338.70,11.33,1.11,'PN16','condotta',''),
(19,42.245920,13.805440,0,334.03,0.0,4.8922,338.63,4.60,0.45,'PN16','condotta',''),
(20,42.247340,13.802900,0,341.47,0.0,5.1542,338.56,-2.91,0.00,'PN16','galleria','Galleria breve (deficit 3m)'),
(21,42.248970,13.800700,0,338.90,0.0,5.4104,338.49,-0.42,0.00,'PN16','galleria','Galleria breve (deficit 0m)'),
(22,42.251040,13.799240,0,336.86,0.0,5.6701,338.41,1.55,0.15,'PN16','condotta',''),
(23,42.253210,13.798770,0,334.08,0.0,5.9145,338.34,4.27,0.42,'PN16','condotta',''),
(24,42.255600,13.799610,0,338.83,0.0,6.1891,338.27,-0.56,0.00,'PN16','galleria','Galleria breve (deficit 1m)'),
(25,42.257890,13.799180,0,344.75,0.0,6.4462,338.20,-6.55,0.00,'PN16','galleria','Galleria breve (deficit 7m)'),
(26,42.260110,13.798400,0,345.81,0.0,6.7012,338.12,-7.69,0.00,'PN16','galleria','Galleria breve (deficit 8m)'),
(27,42.262130,13.796950,0,349.13,0.0,6.9556,338.05,-11.08,0.00,'PN16','galleria','Galleria breve (deficit 11m)'),
(28,42.263580,13.794540,0,346.50,0.0,7.2112,337.98,-8.52,0.00,'PN16','galleria','Galleria breve (deficit 9m)'),
(29,42.264520,13.791620,0,349.42,0.0,7.4732,337.91,-11.52,0.00,'PN16','galleria','Galleria breve (deficit 12m)'),
(30,42.265540,13.788720,0,350.62,0.0,7.7374,337.83,-12.79,0.00,'PN16','galleria','Galleria breve (deficit 13m)'),
(31,42.267080,13.786190,0,348.54,0.0,8.0070,337.76,-10.78,0.00,'PN16','galleria','Galleria breve (deficit 11m)'),
(32,42.268820,13.784270,0,340.87,0.0,8.2568,337.69,-3.19,0.00,'PN16','galleria','Galleria breve (deficit 3m)'),
(33,42.270020,13.781840,0,335.19,0.0,8.4971,337.62,2.43,0.24,'PN16','condotta',''),
(34,42.272000,13.781870,0,331.98,0.0,8.7173,337.56,5.58,0.55,'PN16','condotta',''),
(35,42.273630,13.784090,0,340.11,0.0,8.9746,337.49,-2.62,0.00,'PN16','galleria','Galleria breve (deficit 3m)'),
(36,42.274310,13.786370,0,338.66,0.0,9.1769,337.43,-1.23,0.00,'PN16','galleria','Galleria breve (deficit 1m)'),
(37,42.272790,13.789150,0,336.39,0.0,9.4613,337.35,0.96,0.09,'PN16','condotta',''),
(38,42.271200,13.791620,0,331.24,0.0,9.7307,337.28,6.04,0.59,'PN16','condotta',''),
(39,42.269440,13.794340,0,330.67,0.0,10.0280,337.19,6.52,0.64,'PN16','condotta',''),
(40,42.267990,13.796730,0,333.83,0.0,10.2823,337.12,3.29,0.32,'PN16','condotta',''),
(41,42.266800,13.799650,0,337.64,0.0,10.5566,337.04,-0.60,0.00,'PN16','galleria','Galleria breve (deficit 1m)'),
(42,42.265440,13.802160,0,349.65,0.0,10.8126,336.97,-12.68,0.00,'PN16','galleria','Galleria breve (deficit 13m)'),
(43,42.263120,13.803720,0,359.46,0.0,11.1007,336.89,-22.57,0.00,'PN16','galleria','Galleria breve (deficit 23m)'),
(44,42.260950,13.804900,0,370.69,0.0,11.3608,336.82,-33.87,0.00,'PN16','galleria','Galleria breve (deficit 34m)'),
(45,42.258610,13.806160,0,376.50,0.0,11.6409,336.74,-39.76,0.00,'PN16','galleria','Galleria breve (deficit 40m)'),
(46,42.256440,13.807330,0,378.26,0.0,11.9007,336.67,-41.59,0.00,'PN16','galleria','Galleria breve (deficit 42m)'),
(47,42.254280,13.808510,0,377.61,0.0,12.1598,336.60,-41.01,0.00,'PN16','galleria','Galleria breve (deficit 41m)'),
(48,42.252350,13.809600,0,366.28,0.0,12.3924,336.53,-29.75,0.00,'PN16','galleria','Galleria breve (deficit 30m)'),
(49,42.250310,13.811370,0,358.97,0.0,12.6620,336.45,-22.52,0.00,'PN16','galleria','Galleria breve (deficit 23m)');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(50,42.248360,13.813050,0,351.46,0.0,12.9192,336.38,-15.08,0.00,'PN16','galleria','Galleria breve (deficit 15m)'),
(51,42.246390,13.814550,0,344.46,0.0,13.1706,336.31,-8.14,0.00,'PN16','galleria','Galleria breve (deficit 8m)'),
(52,42.244090,13.814920,0,337.56,0.0,13.4282,336.24,-1.32,0.00,'PN16','galleria','Galleria breve (deficit 1m)'),
(53,42.241810,13.814710,0,320.98,0.0,13.6823,336.17,15.19,1.49,'PN16','condotta',''),
(54,42.239720,13.813970,0,321.58,0.0,13.9225,336.10,14.52,1.42,'PN16','condotta',''),
(55,42.237450,13.813900,0,321.76,0.0,14.1750,336.03,14.27,1.40,'PN16','condotta',''),
(56,42.235190,13.813750,0,323.73,0.0,14.4266,335.96,12.23,1.20,'PN16','condotta',''),
(57,42.233010,13.814760,0,323.62,0.0,14.6829,335.89,12.27,1.20,'PN16','condotta',''),
(58,42.230420,13.814560,0,322.04,0.0,14.9713,335.81,13.77,1.35,'PN16','condotta',''),
(59,42.228040,13.814820,0,320.47,0.0,15.2368,335.73,15.26,1.50,'PN16','condotta',''),
(60,42.225780,13.815300,0,319.75,0.0,15.4912,335.66,15.92,1.56,'PN16','condotta',''),
(61,42.223590,13.816610,0,317.50,0.0,15.7576,335.59,18.09,1.77,'PN16','condotta',''),
(62,42.221470,13.817440,0,318.52,0.0,16.0030,335.52,17.00,1.67,'PN16','condotta',''),
(63,42.219140,13.817070,0,318.67,0.0,16.2639,335.45,16.78,1.65,'PN16','condotta',''),
(64,42.216900,13.817660,0,319.61,0.0,16.5177,335.38,15.76,1.55,'PN16','condotta',''),
(65,42.215040,13.819550,0,322.88,0.0,16.7765,335.30,12.42,1.22,'PN16','condotta',''),
(66,42.213170,13.820410,0,313.19,0.0,16.9962,335.24,22.06,2.16,'PN16','condotta',''),
(67,42.213990,13.822080,0,315.98,0.0,17.1612,335.19,19.22,1.88,'PN16','condotta',''),
(68,42.215740,13.819680,0,316.93,0.0,17.4385,335.12,18.18,1.78,'PN16','condotta',''),
(69,42.216240,13.818880,0,317.61,0.0,17.5248,335.09,17.48,1.71,'PN16','condotta',''),
(70,42.214710,13.821270,0,316.14,0.0,17.7849,335.02,18.88,1.85,'PN16','condotta',''),
(71,42.213140,13.821820,0,313.49,0.0,17.9653,334.97,21.48,2.11,'PN16','condotta',''),
(72,42.213280,13.820690,0,315.78,0.0,18.0596,334.94,19.16,1.88,'PN16','condotta',''),
(73,42.211180,13.822060,0,314.12,0.0,18.3190,334.87,20.75,2.03,'PN16','condotta',''),
(74,42.208990,13.823510,0,315.31,0.0,18.5902,334.79,19.48,1.91,'PN16','condotta',''),
(75,42.207320,13.825750,0,309.31,0.0,18.8520,334.72,25.42,2.49,'PN16','condotta',''),
(76,42.205880,13.828260,0,297.98,0.0,19.1134,334.65,36.66,3.59,'PN16','condotta',''),
(77,42.205250,13.831700,0,284.82,0.0,19.4053,334.57,49.75,4.88,'PN16','condotta',''),
(78,42.204010,13.835020,0,266.75,0.0,19.7116,334.48,67.73,6.64,'PN16','condotta',''),
(79,42.202340,13.837080,0,258.27,0.0,19.9631,334.41,76.14,7.47,'PN16','condotta',''),
(80,42.200110,13.837500,0,260.51,0.0,20.2135,334.34,73.83,7.24,'PN16','condotta',''),
(81,42.197880,13.837470,0,261.46,0.0,20.4615,334.27,72.82,7.14,'PN16','condotta',''),
(82,42.196120,13.839350,0,263.73,0.0,20.7110,334.20,70.47,6.91,'PN16','condotta',''),
(83,42.195570,13.842430,0,263.22,0.0,20.9720,334.13,70.90,6.95,'PN16','condotta',''),
(84,42.192030,13.846140,0,256.99,0.0,21.4704,333.99,77.00,7.55,'PN16','condotta',''),
(85,42.190170,13.847380,0,241.78,0.0,21.7011,333.92,92.14,9.03,'PN16','condotta',''),
(86,42.188830,13.844850,0,251.97,0.0,21.9573,333.85,81.89,8.03,'PN16','condotta',''),
(87,42.186830,13.843470,0,248.94,0.0,22.2070,333.78,84.84,8.32,'PN16','condotta',''),
(88,42.184900,13.841920,0,249.61,0.0,22.4568,333.71,84.10,8.25,'PN16','condotta',''),
(89,42.182800,13.840690,0,249.89,0.0,22.7113,333.64,83.75,8.21,'PN16','condotta',''),
(90,42.180820,13.839190,0,251.41,0.0,22.9638,333.57,82.16,8.05,'PN16','condotta',''),
(91,42.178590,13.839280,0,251.32,0.0,23.2119,333.50,82.18,8.06,'PN16','condotta',''),
(92,42.176500,13.837810,0,248.42,0.0,23.4740,333.43,85.01,8.33,'PN16','condotta',''),
(93,42.175110,13.835450,0,244.77,0.0,23.7224,333.36,88.58,8.68,'PN16','condotta',''),
(94,42.175550,13.832430,0,243.95,0.0,23.9760,333.29,89.33,8.76,'PN16','condotta',''),
(95,42.174040,13.830470,0,246.15,0.0,24.2090,333.22,87.07,8.54,'PN16','condotta',''),
(96,42.171690,13.829800,0,246.11,0.0,24.4761,333.15,87.04,8.53,'PN16','condotta',''),
(97,42.169480,13.830480,0,246.68,0.0,24.7281,333.08,86.40,8.47,'PN16','condotta',''),
(98,42.167280,13.831190,0,247.02,0.0,24.9796,333.01,85.98,8.43,'PN16','condotta',''),
(99,42.166000,13.833480,0,250.20,0.0,25.2160,332.94,82.74,8.11,'PN16','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(100,42.165730,13.836490,0,252.95,0.0,25.4659,332.87,79.92,7.84,'PN16','condotta',''),
(101,42.167420,13.835930,0,268.99,0.0,25.6594,332.82,63.83,6.26,'PN16','condotta',''),
(102,42.168200,13.837840,0,296.67,0.0,25.8392,332.77,36.09,3.54,'PN16','condotta',''),
(103,42.167650,13.836190,0,271.51,0.0,25.9883,332.72,61.21,6.00,'PN16','condotta',''),
(104,42.166910,13.834360,0,257.55,0.0,26.1601,332.68,75.12,7.37,'PN16','condotta',''),
(105,42.166520,13.832080,0,248.01,0.0,26.3529,332.62,84.62,8.30,'PN16','condotta',''),
(106,42.168690,13.830860,0,247.08,0.0,26.6143,332.55,85.47,8.38,'PN16','condotta',''),
(107,42.170850,13.829910,0,247.06,0.0,26.8669,332.48,85.41,8.37,'PN16','condotta',''),
(108,42.173160,13.830010,0,246.12,0.0,27.1239,332.41,86.28,8.46,'PN16','condotta',''),
(109,42.175230,13.831270,0,247.65,0.0,27.3764,332.33,84.68,8.30,'PN16','condotta',''),
(110,42.175250,13.834410,0,243.11,0.0,27.6352,332.26,89.15,8.74,'PN16','condotta',''),
(111,42.175920,13.837070,0,248.60,0.0,27.8667,332.20,83.59,8.20,'PN16','condotta',''),
(112,42.177740,13.838800,0,248.22,0.0,28.1143,332.13,83.90,8.23,'PN16','condotta',''),
(113,42.180120,13.839130,0,250.80,0.0,28.3803,332.05,81.25,7.97,'PN16','condotta',''),
(114,42.182180,13.840170,0,253.77,0.0,28.6249,331.99,78.22,7.67,'PN16','condotta',''),
(115,42.184190,13.841530,0,252.96,0.0,28.8749,331.92,78.96,7.74,'PN16','condotta',''),
(116,42.186210,13.843030,0,252.03,0.0,29.1313,331.84,79.81,7.82,'PN16','condotta',''),
(117,42.188260,13.844290,0,250.86,0.0,29.3817,331.77,80.91,7.93,'PN16','condotta',''),
(118,42.189710,13.846580,0,243.98,0.0,29.6299,331.70,87.73,8.60,'PN16','condotta',''),
(119,42.191020,13.849190,0,241.01,0.0,29.8896,331.63,90.62,8.88,'PN16','condotta',''),
(120,42.192730,13.851390,0,243.59,0.0,30.1523,331.56,87.96,8.62,'PN16','condotta',''),
(121,42.194880,13.852310,0,240.69,0.0,30.4031,331.49,90.80,8.90,'PN16','condotta',''),
(122,42.195900,13.855030,0,240.64,0.0,30.6543,331.42,90.78,8.90,'PN16','condotta',''),
(123,42.195740,13.858050,0,241.73,0.0,30.9037,331.35,89.62,8.79,'PN16','condotta',''),
(124,42.195520,13.861270,0,241.44,0.0,31.1701,331.27,89.83,8.81,'PN16','condotta',''),
(125,42.196250,13.864190,0,239.66,0.0,31.4239,331.20,91.54,8.97,'PN16','condotta',''),
(126,42.197130,13.867260,0,241.16,0.0,31.6951,331.13,89.96,8.82,'PN16','condotta',''),
(127,42.197630,13.870690,0,229.48,0.0,31.9831,331.04,101.57,9.96,'PN16','condotta',''),
(128,42.198150,13.874260,0,225.84,0.0,32.2828,330.96,105.12,10.31,'PN16','condotta',''),
(129,42.197950,13.877230,0,235.65,0.0,32.5285,330.89,95.24,9.34,'PN16','condotta',''),
(130,42.199230,13.879720,0,221.68,0.0,32.7781,330.82,109.15,10.70,'PN16','condotta',''),
(131,42.199570,13.882620,0,216.90,0.0,33.0200,330.75,113.85,11.16,'PN16','condotta',''),
(132,42.200780,13.885100,0,218.42,0.0,33.2646,330.69,112.26,11.01,'PN16','condotta',''),
(133,42.202640,13.887170,0,216.47,0.0,33.5326,330.61,114.14,11.19,'PN16','condotta',''),
(134,42.204280,13.889220,0,217.47,0.0,33.7812,330.54,113.07,11.08,'PN16','condotta',''),
(135,42.205690,13.891940,0,220.81,0.0,34.0546,330.46,109.66,10.75,'PN16','condotta',''),
(136,42.207440,13.893860,0,221.11,0.0,34.3054,330.39,109.28,10.71,'PN16','condotta',''),
(137,42.209380,13.895830,0,214.96,0.0,34.5753,330.32,115.36,11.31,'PN16','condotta',''),
(138,42.210910,13.898410,0,215.54,0.0,34.8475,330.24,114.71,11.25,'PN16','condotta',''),
(139,42.211840,13.901210,0,216.91,0.0,35.1002,330.17,113.26,11.10,'PN16','condotta',''),
(140,42.213700,13.902940,0,211.19,0.0,35.3514,330.10,118.91,11.66,'PN16','condotta',''),
(141,42.215780,13.904620,0,215.56,0.0,35.6209,330.03,114.47,11.22,'PN16','condotta',''),
(142,42.217820,13.906020,0,219.58,0.0,35.8753,329.95,110.37,10.82,'PN16','condotta',''),
(143,42.219670,13.908430,0,219.56,0.0,36.1612,329.87,110.31,10.82,'PN16','condotta',''),
(144,42.221350,13.910630,0,214.89,0.0,36.4214,329.80,114.91,11.27,'PN16','condotta',''),
(145,42.222660,13.913090,0,215.25,0.0,36.6709,329.73,114.48,11.22,'PN16','condotta',''),
(146,42.224440,13.915210,0,212.18,0.0,36.9348,329.66,117.48,11.52,'PN16','condotta',''),
(147,42.225510,13.918130,0,205.29,0.0,37.2031,329.58,124.30,12.19,'PN16','condotta',''),
(148,42.226120,13.921100,0,207.19,0.0,37.4569,329.51,122.33,11.99,'PN16','condotta',''),
(149,42.226070,13.924160,0,208.47,0.0,37.7089,329.44,120.97,11.86,'PN16','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(150,42.225960,13.926940,0,206.98,0.0,37.9381,329.38,122.40,12.00,'PN16','condotta',''),
(151,42.225930,13.930020,0,198.57,0.0,38.1917,329.31,130.73,12.82,'PN16','condotta',''),
(152,42.225870,13.933080,0,194.80,0.0,38.4438,329.24,134.43,13.18,'PN16','condotta',''),
(153,42.225800,13.936290,0,198.01,0.0,38.7082,329.16,131.15,12.86,'PN16','condotta',''),
(154,42.225730,13.939410,0,197.01,0.0,38.9652,329.09,132.08,12.95,'PN16','condotta',''),
(155,42.226270,13.942680,0,194.56,0.0,39.2411,329.01,134.45,13.18,'PN16','condotta',''),
(156,42.227160,13.945770,0,201.70,0.0,39.5141,328.94,127.24,12.47,'PN16','condotta',''),
(157,42.228390,13.948690,0,212.49,0.0,39.7907,328.86,116.37,11.41,'PN16','condotta',''),
(158,42.230390,13.950120,0,231.91,0.0,40.0423,328.79,96.88,9.50,'PN16','condotta',''),
(159,42.232750,13.950770,0,246.64,0.0,40.3102,328.71,82.07,8.05,'PN16','condotta',''),
(160,42.235150,13.951530,0,231.98,0.0,40.5843,328.64,96.65,9.48,'PN16','condotta',''),
(161,42.237110,13.952920,0,220.74,0.0,40.8304,328.57,107.83,10.57,'PN16','condotta',''),
(162,42.239220,13.952880,0,210.85,0.0,41.0651,328.50,117.65,11.53,'PN16','condotta',''),
(163,42.240370,13.950690,0,201.72,0.0,41.2861,328.44,126.72,12.42,'PN16','condotta',''),
(164,42.242610,13.951200,0,182.58,0.0,41.5387,328.37,145.79,14.29,'PN16','condotta',''),
(165,42.244820,13.950600,0,164.63,0.0,41.7893,328.30,163.67,16.05,'PN25','condotta',''),
(166,42.246710,13.952050,0,146.06,0.0,42.0310,328.23,182.17,17.86,'PN25','condotta',''),
(167,42.249700,13.951800,0,138.54,0.0,42.3641,328.14,189.60,18.59,'PN25','condotta',''),
(168,42.251150,13.950460,0,133.61,0.0,42.5595,328.08,194.47,19.07,'PN25','condotta',''),
(169,42.252000,13.950480,0,128.74,0.0,42.6540,328.06,199.31,19.54,'PN25','condotta',''),
(170,42.251300,13.951670,0,135.57,0.0,42.7791,328.02,192.45,18.87,'PN25','condotta',''),
(171,42.253640,13.952000,0,134.01,0.0,43.0407,327.95,193.94,19.01,'PN25','condotta',''),
(172,42.255990,13.951240,0,139.97,0.0,43.3094,327.87,187.91,18.42,'PN25','condotta',''),
(173,42.258280,13.951240,0,139.92,0.0,43.5641,327.80,187.88,18.42,'PN25','condotta',''),
(174,42.260230,13.952920,0,140.22,0.0,43.8212,327.73,187.51,18.38,'PN25','condotta',''),
(175,42.261100,13.956000,0,139.68,0.0,44.0925,327.65,187.97,18.43,'PN25','condotta',''),
(176,42.262030,13.958880,0,139.34,0.0,44.3511,327.58,188.24,18.45,'PN25','condotta',''),
(177,42.262490,13.962100,0,136.08,0.0,44.6210,327.51,191.42,18.77,'PN25','condotta',''),
(178,42.263880,13.964700,0,139.08,0.0,44.8849,327.43,188.35,18.47,'PN25','condotta',''),
(179,42.265020,13.967440,0,134.65,0.0,45.1436,327.36,192.71,18.89,'PN25','condotta',''),
(180,42.265800,13.970390,0,144.88,0.0,45.4014,327.29,182.41,17.88,'PN25','condotta',''),
(181,42.265710,13.973490,0,143.70,0.0,45.6567,327.22,183.52,17.99,'PN25','condotta',''),
(182,42.266560,13.976420,0,153.82,0.0,45.9156,327.14,173.33,16.99,'PN25','condotta',''),
(183,42.266710,13.979620,0,161.50,0.0,46.1795,327.07,165.56,16.23,'PN25','condotta',''),
(184,42.266900,13.982870,0,161.16,0.0,46.4477,326.99,165.83,16.26,'PN25','condotta',''),
(185,42.267080,13.986000,0,149.91,0.0,46.7061,326.92,177.01,17.35,'PN25','condotta',''),
(186,42.266620,13.989070,0,134.13,0.0,46.9638,326.85,192.72,18.89,'PN25','condotta',''),
(187,42.266660,13.992230,0,121.77,0.0,47.2239,326.78,205.01,20.10,'PN25','condotta',''),
(188,42.266040,13.995110,0,122.45,0.0,47.4707,326.71,204.26,20.03,'PN25','condotta',''),
(189,42.265670,13.998010,0,120.47,0.0,47.7128,326.64,206.18,20.21,'PN25','condotta',''),
(190,42.264020,14.000040,0,117.90,0.0,47.9610,326.57,208.67,20.46,'PN25','condotta',''),
(191,42.263540,14.002550,0,111.96,0.0,48.1743,326.51,214.56,21.03,'PN25','condotta',''),
(192,42.264810,14.005460,0,103.98,0.0,48.4523,326.43,222.45,21.81,'PN25','condotta',''),
(193,42.266160,14.008010,0,103.01,0.0,48.7103,326.36,223.35,21.90,'PN25','condotta',''),
(194,42.267310,14.010520,0,101.87,0.0,48.9532,326.29,224.43,22.00,'PN25','condotta',''),
(195,42.268770,14.013470,0,91.14,0.0,49.2453,326.21,235.07,23.05,'PN25','condotta',''),
(196,42.270130,14.013890,0,93.16,0.0,49.4004,326.17,233.01,22.84,'PN25','condotta',''),
(197,42.271740,14.011770,0,99.53,0.0,49.6503,326.10,226.57,22.21,'PN25','condotta',''),
(198,42.273580,14.010230,0,99.73,0.0,49.8910,326.03,226.30,22.19,'PN25','condotta',''),
(199,42.274820,14.012370,0,100.06,0.0,50.1146,325.97,225.91,22.15,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(200,42.276950,14.012530,0,97.57,0.0,50.3518,325.90,228.33,22.39,'PN25','condotta',''),
(201,42.280050,14.014660,0,92.41,0.0,50.7385,325.79,233.38,22.88,'PN25','condotta',''),
(202,42.282210,14.014270,0,91.63,0.0,50.9808,325.73,234.10,22.95,'PN25','condotta',''),
(203,42.284230,14.012780,0,92.38,0.0,51.2367,325.65,233.27,22.87,'PN25','condotta',''),
(204,42.285400,14.014520,0,86.22,0.0,51.4301,325.60,239.38,23.47,'PN25','condotta',''),
(205,42.286040,14.017440,0,84.06,0.0,51.6807,325.53,241.47,23.67,'PN25','condotta',''),
(206,42.287640,14.019530,0,81.52,0.0,51.9281,325.46,243.94,23.92,'PN25','condotta',''),
(207,42.289660,14.020980,0,80.27,0.0,52.1824,325.39,245.12,24.03,'PN25','condotta',''),
(208,42.291680,14.022600,0,78.86,0.0,52.4436,325.32,246.46,24.16,'PN25','condotta',''),
(209,42.293960,14.024270,0,75.22,0.0,52.7319,325.24,250.01,24.51,'PN25','condotta',''),
(210,42.295940,14.025740,0,74.60,0.0,52.9831,325.16,250.57,24.57,'PN25','condotta',''),
(211,42.297990,14.027260,0,75.49,0.0,53.2431,325.09,249.60,24.47,'PN25','condotta',''),
(212,42.300550,14.029170,0,74.75,0.0,53.5682,325.00,250.25,24.53,'PN25','condotta',''),
(213,42.302530,14.031000,0,80.46,0.0,53.8349,324.93,244.47,23.97,'PN25','condotta',''),
(214,42.304460,14.032690,0,80.93,0.0,54.0906,324.85,243.92,23.91,'PN25','condotta',''),
(215,42.306510,14.034100,0,80.54,0.0,54.3463,324.78,244.25,23.95,'PN25','condotta',''),
(216,42.307760,14.036820,0,78.84,0.0,54.6097,324.71,245.87,24.11,'PN25','condotta',''),
(217,42.309080,14.039460,0,67.26,0.0,54.8717,324.64,257.38,25.23,'PN40','condotta',''),
(218,42.310660,14.041770,0,62.66,0.0,55.1305,324.56,261.91,25.68,'PN40','condotta',''),
(219,42.311970,14.044410,0,64.65,0.0,55.3919,324.49,259.84,25.47,'PN40','condotta',''),
(220,42.313710,14.046230,0,64.84,0.0,55.6365,324.42,259.58,25.45,'PN40','condotta',''),
(221,42.315010,14.049140,0,60.71,0.0,55.9160,324.34,263.63,25.85,'PN40','condotta',''),
(222,42.316230,14.051810,0,60.48,0.0,56.1741,324.27,263.79,25.86,'PN40','condotta',''),
(223,42.318420,14.054310,0,56.92,0.0,56.4928,324.18,267.26,26.20,'PN40','condotta',''),
(224,42.320140,14.056550,0,55.04,0.0,56.7583,324.11,269.07,26.38,'PN40','condotta',''),
(225,42.321250,14.059310,0,53.12,0.0,57.0166,324.04,270.92,26.56,'PN40','condotta',''),
(226,42.323120,14.061120,0,54.43,0.0,57.2723,323.96,269.53,26.42,'PN40','condotta',''),
(227,42.325020,14.063810,0,53.14,0.0,57.5781,323.88,270.74,26.54,'PN40','condotta',''),
(228,42.326500,14.066120,0,51.84,0.0,57.8294,323.81,271.96,26.66,'PN40','condotta',''),
(229,42.328180,14.068580,0,53.01,0.0,58.1047,323.73,270.72,26.54,'PN40','condotta',''),
(230,42.329920,14.071110,0,49.39,0.0,58.3888,323.65,274.26,26.89,'PN40','condotta',''),
(231,42.331470,14.073380,0,50.07,0.0,58.6428,323.58,273.51,26.81,'PN40','condotta',''),
(232,42.333100,14.075760,0,49.97,0.0,58.9095,323.51,273.54,26.82,'PN40','condotta',''),
(233,42.334350,14.078590,0,49.26,0.0,59.1805,323.43,274.17,26.88,'PN40','condotta',''),
(234,42.334360,14.081950,0,52.90,0.0,59.4567,323.35,270.45,26.51,'PN40','condotta',''),
(235,42.335430,14.084590,0,55.29,0.0,59.7042,323.28,267.99,26.27,'PN40','condotta',''),
(236,42.336350,14.087700,0,53.34,0.0,59.9795,323.21,269.87,26.46,'PN40','condotta',''),
(237,42.337220,14.090740,0,53.05,0.0,60.2474,323.13,270.08,26.48,'PN40','condotta',''),
(238,42.337910,14.093810,0,54.53,0.0,60.5112,323.06,268.53,26.33,'PN40','condotta',''),
(239,42.338540,14.096990,0,54.56,0.0,60.7818,322.98,268.42,26.32,'PN40','condotta',''),
(240,42.338920,14.100110,0,55.07,0.0,61.0417,322.91,267.83,26.26,'PN40','condotta',''),
(241,42.339690,14.103150,0,53.19,0.0,61.3058,322.83,269.65,26.44,'PN40','condotta',''),
(242,42.340860,14.106580,0,51.10,0.0,61.6163,322.75,271.65,26.63,'PN40','condotta',''),
(243,42.342150,14.109250,0,52.34,0.0,61.8785,322.67,270.34,26.50,'PN40','condotta',''),
(244,42.343570,14.111420,0,51.22,0.0,62.1167,322.61,271.39,26.61,'PN40','condotta',''),
(245,42.346120,14.112660,0,47.45,0.0,62.4180,322.52,275.07,26.97,'PN40','condotta',''),
(246,42.348300,14.113660,0,45.18,0.0,62.6739,322.45,277.27,27.18,'PN40','condotta',''),
(247,42.350030,14.112100,0,46.47,0.0,62.9051,322.39,275.91,27.05,'PN40','condotta',''),
(248,42.350930,14.109370,0,61.53,0.0,63.1507,322.32,260.78,25.57,'PN40','condotta',''),
(249,42.351840,14.106410,0,70.56,0.0,63.4142,322.24,251.68,24.67,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(250,42.352380,14.103210,0,72.88,0.0,63.6839,322.17,249.29,24.44,'PN25','condotta',''),
(251,42.353670,14.100140,0,80.28,0.0,63.9741,322.09,241.81,23.71,'PN25','condotta',''),
(252,42.354310,14.096840,0,96.60,0.0,64.2545,322.01,225.41,22.10,'PN25','condotta',''),
(253,42.355230,14.093880,0,110.15,0.0,64.5183,321.93,211.79,20.76,'PN25','condotta',''),
(254,42.356510,14.091230,0,113.22,0.0,64.7785,321.86,208.64,20.45,'PN25','condotta',''),
(255,42.357730,14.088540,0,110.91,0.0,65.0378,321.79,210.88,20.67,'PN25','condotta',''),
(256,42.358500,14.085680,0,114.06,0.0,65.2879,321.72,207.66,20.36,'PN25','condotta',''),
(257,42.359410,14.082910,0,114.82,0.0,65.5370,321.65,206.83,20.28,'PN25','condotta',''),
(258,42.360590,14.080260,0,119.60,0.0,65.7912,321.58,201.98,19.80,'PN25','condotta',''),
(259,42.361710,14.077330,0,128.45,0.0,66.0623,321.50,193.05,18.93,'PN25','condotta',''),
(260,42.363010,14.075860,0,134.88,0.0,66.2506,321.45,186.56,18.29,'PN25','condotta',''),
(261,42.364750,14.077870,0,131.89,0.0,66.5050,321.38,189.49,18.58,'PN25','condotta',''),
(262,42.365970,14.080950,0,127.93,0.0,66.7921,321.30,193.37,18.96,'PN25','condotta',''),
(263,42.365710,14.084800,0,117.06,0.0,67.1098,321.21,204.15,20.01,'PN25','condotta',''),
(264,42.365490,14.087900,0,112.63,0.0,67.3656,321.14,208.51,20.44,'PN25','condotta',''),
(265,42.365280,14.091020,0,106.87,0.0,67.6230,321.07,214.20,21.00,'PN25','condotta',''),
(266,42.365010,14.094940,0,102.25,0.0,67.9465,320.97,218.73,21.44,'PN25','condotta',''),
(267,42.365630,14.097900,0,102.28,0.0,68.1992,320.90,218.63,21.43,'PN25','condotta',''),
(268,42.367110,14.100630,0,98.40,0.0,68.4774,320.83,222.42,21.81,'PN25','condotta',''),
(269,42.368600,14.103380,0,95.10,0.0,68.7576,320.75,225.65,22.12,'PN25','condotta',''),
(270,42.369980,14.105920,0,91.69,0.0,69.0166,320.68,228.98,22.45,'PN25','condotta',''),
(271,42.371470,14.108670,0,88.58,0.0,69.2968,320.60,232.02,22.75,'PN25','condotta',''),
(272,42.372910,14.111340,0,84.92,0.0,69.5683,320.52,235.60,23.10,'PN25','condotta',''),
(273,42.373220,14.114080,0,81.65,0.0,69.7960,320.46,238.81,23.41,'PN25','condotta',''),
(274,42.372170,14.116780,0,69.00,0.0,70.0467,320.39,251.38,24.65,'PN25','condotta',''),
(275,42.372320,14.119740,0,53.39,0.0,70.2904,320.32,266.93,26.17,'PN40','condotta',''),
(276,42.373910,14.122200,0,39.22,0.0,70.5589,320.24,281.02,27.55,'PN40','condotta',''),
(277,42.375710,14.123930,0,35.00,0.0,70.8044,320.17,285.18,27.96,'PN40','condotta',''),
(278,42.376160,14.126240,0,26.62,0.0,71.0006,320.12,293.50,28.77,'PN40','condotta',''),
(279,42.375570,14.129250,0,23.46,0.0,71.2564,320.05,296.59,29.08,'PN40','condotta',''),
(280,42.374430,14.131720,0,31.64,0.0,71.4957,319.98,288.35,28.27,'PN40','condotta',''),
(281,42.373860,14.134750,0,33.81,0.0,71.7525,319.91,286.10,28.05,'PN40','condotta',''),
(282,42.373060,14.138080,0,32.70,0.0,72.0402,319.83,287.13,28.15,'PN40','condotta',''),
(283,42.374040,14.139280,0,31.10,0.0,72.1871,319.79,288.69,28.30,'PN40','condotta',''),
(284,42.375180,14.136710,0,30.72,0.0,72.4334,319.72,289.00,28.33,'PN40','condotta',''),
(285,42.377390,14.137080,0,29.38,0.0,72.6810,319.65,290.27,28.46,'PN40','condotta',''),
(286,42.379490,14.138240,0,23.85,0.0,72.9332,319.58,295.73,28.99,'PN40','condotta',''),
(287,42.380790,14.140720,0,28.98,0.0,73.1830,319.51,290.53,28.48,'PN40','condotta',''),
(288,42.381060,14.143800,0,29.38,0.0,73.4377,319.44,290.06,28.44,'PN40','condotta',''),
(289,42.381180,14.147020,0,29.60,0.0,73.7025,319.36,289.76,28.41,'PN40','condotta',''),
(290,42.382050,14.149850,0,25.91,0.0,73.9543,319.29,293.38,28.76,'PN40','condotta',''),
(291,42.383980,14.151870,0,28.98,0.0,74.2256,319.22,290.23,28.45,'PN40','condotta',''),
(292,42.386660,14.153260,0,30.45,0.0,74.5447,319.13,288.68,28.30,'PN40','condotta',''),
(293,42.388870,14.154050,0,29.99,0.0,74.7989,319.06,289.07,28.34,'PN40','condotta',''),
(294,42.390920,14.155700,0,22.67,0.0,75.0641,318.98,296.31,29.05,'PN40','condotta',''),
(295,42.392700,14.157640,0,16.61,0.0,75.3181,318.91,302.30,29.64,'PN40','condotta',''),
(296,42.394500,14.159600,0,20.58,0.0,75.5750,318.84,298.26,29.24,'PN40','condotta',''),
(297,42.396590,14.161600,0,22.77,0.0,75.8595,318.76,295.99,29.02,'PN40','condotta',''),
(298,42.398660,14.162930,0,23.03,0.0,76.1143,318.69,295.66,28.99,'PN40','condotta',''),
(299,42.400800,14.164140,0,21.39,0.0,76.3722,318.62,297.23,29.14,'PN40','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(300,42.403020,14.163930,0,19.85,0.0,76.6196,318.55,298.69,29.28,'PN40','condotta',''),
(301,42.405080,14.162690,0,25.34,0.0,76.8703,318.48,293.14,28.74,'PN40','condotta',''),
(302,42.407410,14.161940,0,23.43,0.0,77.1366,318.40,294.98,28.92,'PN40','condotta',''),
(303,42.409700,14.162590,0,20.80,0.0,77.3968,318.33,297.53,29.17,'PN40','condotta',''),
(304,42.411870,14.163940,0,22.30,0.0,77.6623,318.25,295.95,29.02,'PN40','condotta',''),
(305,42.414000,14.165370,0,22.03,0.0,77.9267,318.18,296.15,29.03,'PN40','condotta',''),
(306,42.416090,14.166810,0,14.79,0.0,78.1874,318.11,303.32,29.74,'PN40','condotta',''),
(307,42.418210,14.168270,0,13.66,0.0,78.4518,318.03,304.38,29.84,'PN40','condotta',''),
(308,42.420310,14.169720,0,14.68,0.0,78.7139,317.96,303.28,29.73,'PN40','condotta',''),
(309,42.422530,14.171270,0,13.64,0.0,78.9916,317.88,304.24,29.83,'PN40','condotta',''),
(310,42.424390,14.172990,0,14.67,0.0,79.2421,317.81,303.14,29.72,'PN40','condotta',''),
(311,42.426190,14.174840,0,14.34,0.0,79.4933,317.74,303.40,29.75,'PN40','condotta',''),
(312,42.428160,14.176780,0,12.61,0.0,79.7641,317.67,305.06,29.91,'PN40','condotta',''),
(313,42.430560,14.178380,0,10.84,0.0,80.0615,317.58,306.74,30.07,'PN40','condotta',''),
(314,42.432660,14.179500,0,10.72,0.0,80.3125,317.51,306.79,30.08,'PN40','condotta',''),
(315,42.434720,14.180990,0,9.85,0.0,80.5721,317.44,307.59,30.16,'PN40','condotta',''),
(316,42.436830,14.182620,0,10.62,0.0,80.8422,317.36,306.74,30.07,'PN40','condotta',''),
(317,42.438960,14.184250,0,11.72,0.0,81.1142,317.29,305.57,29.96,'PN40','condotta',''),
(318,42.441000,14.185820,0,12.14,0.0,81.3751,317.21,305.08,29.91,'PN40','condotta',''),
(319,42.443090,14.187420,0,10.07,0.0,81.6420,317.14,307.07,30.10,'PN40','condotta',''),
(320,42.445080,14.188920,0,9.68,0.0,81.8952,317.07,307.39,30.14,'PN40','condotta',''),
(321,42.447390,14.189350,0,9.37,0.0,82.1545,317.00,307.63,30.16,'PN40','condotta',''),
(322,42.449640,14.189490,0,13.29,0.0,82.4049,316.93,303.63,29.77,'PN40','condotta',''),
(323,42.451740,14.190750,0,11.90,0.0,82.6603,316.86,304.96,29.90,'PN40','condotta',''),
(324,42.453720,14.192420,0,9.31,0.0,82.9196,316.78,307.47,30.14,'PN40','condotta',''),
(325,42.455580,14.194380,0,7.77,0.0,83.1816,316.71,308.94,30.29,'PN40','condotta',''),
(326,42.457100,14.196820,0,8.45,0.0,83.4436,316.64,308.18,30.21,'PN40','condotta',''),
(327,42.458320,14.199540,0,6.66,0.0,83.7047,316.56,309.90,30.38,'PN40','condotta',''),
(328,42.459440,14.202440,0,5.41,0.0,83.9733,316.49,311.08,30.50,'PN40','condotta',''),
(329,42.460440,14.205210,0,7.01,0.0,84.2262,316.42,309.40,30.33,'PN40','condotta',''),
(330,42.460770,14.208040,0,3.91,0.0,84.4613,316.35,312.44,30.63,'PN40','condotta',''),
(331,42.458810,14.209890,0,4.23,0.0,84.7269,316.28,312.05,30.59,'PN40','condotta',''),
(332,42.458930,14.210750,0,4.83,0.0,84.7987,316.26,311.43,30.53,'PN40','condotta',''),
(333,42.460740,14.209250,0,4.33,0.0,85.0346,316.19,311.86,30.57,'PN40','condotta',''),
(334,42.461030,14.206270,0,5.93,0.0,85.2811,316.12,310.19,30.41,'PN40','condotta',''),
(335,42.460020,14.203430,0,6.54,0.0,85.5398,316.05,309.51,30.34,'PN40','condotta',''),
(336,42.458960,14.200690,0,5.75,0.0,85.7936,315.98,310.22,30.41,'PN40','condotta',''),
(337,42.457770,14.198060,0,7.62,0.0,86.0467,315.91,308.29,30.22,'PN40','condotta',''),
(338,42.456330,14.195270,0,7.51,0.0,86.3260,315.83,308.31,30.23,'PN40','condotta',''),
(339,42.454650,14.193190,0,8.48,0.0,86.5790,315.76,307.28,30.13,'PN40','condotta',''),
(340,42.452260,14.191010,0,11.28,0.0,86.8993,315.67,304.39,29.84,'PN40','condotta',''),
(341,42.450240,14.189670,0,13.11,0.0,87.1494,315.60,302.48,29.66,'PN40','condotta',''),
(342,42.448010,14.189160,0,10.92,0.0,87.4009,315.53,304.61,29.86,'PN40','condotta',''),
(343,42.445770,14.189150,0,10.31,0.0,87.6500,315.46,305.15,29.92,'PN40','condotta',''),
(344,42.443640,14.187720,0,10.90,0.0,87.9143,315.38,304.48,29.85,'PN40','condotta',''),
(345,42.440920,14.185630,0,12.77,0.0,88.2620,315.29,302.51,29.66,'PN40','condotta',''),
(346,42.438860,14.184040,0,11.34,0.0,88.5256,315.21,303.87,29.79,'PN40','condotta',''),
(347,42.436490,14.182230,0,9.66,0.0,88.8281,315.13,305.47,29.95,'PN40','condotta',''),
(348,42.434420,14.180640,0,10.77,0.0,89.0927,315.05,304.28,29.83,'PN40','condotta',''),
(349,42.432330,14.179200,0,10.39,0.0,89.3534,314.98,304.59,29.86,'PN40','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(350,42.429960,14.177970,0,11.39,0.0,89.6356,314.90,303.51,29.76,'PN40','condotta',''),
(351,42.427850,14.176360,0,13.06,0.0,89.9049,314.83,301.76,29.58,'PN40','condotta',''),
(352,42.425580,14.174100,0,14.12,0.0,90.2181,314.74,300.62,29.47,'PN40','condotta',''),
(353,42.423750,14.172200,0,13.25,0.0,90.4745,314.67,301.42,29.55,'PN40','condotta',''),
(354,42.421730,14.170570,0,14.90,0.0,90.7359,314.59,299.69,29.38,'PN40','condotta',''),
(355,42.419520,14.169040,0,13.84,0.0,91.0119,314.52,300.67,29.48,'PN40','condotta',''),
(356,42.417460,14.167630,0,13.61,0.0,91.2686,314.44,300.84,29.49,'PN40','condotta',''),
(357,42.415140,14.166030,0,17.92,0.0,91.5581,314.36,296.45,29.06,'PN40','condotta',''),
(358,42.412580,14.164260,0,21.83,0.0,91.8777,314.27,292.45,28.67,'PN40','condotta',''),
(359,42.410240,14.162790,0,19.26,0.0,92.1645,314.19,294.93,28.91,'PN40','condotta',''),
(360,42.407880,14.161850,0,24.14,0.0,92.4380,314.12,289.98,28.43,'PN40','condotta',''),
(361,42.405630,14.162240,0,24.35,0.0,92.6902,314.05,289.70,28.40,'PN40','condotta',''),
(362,42.403450,14.163560,0,21.24,0.0,92.9558,313.97,292.73,28.70,'PN40','condotta',''),
(363,42.401250,14.164130,0,20.19,0.0,93.2048,313.90,293.71,28.80,'PN40','condotta',''),
(364,42.398890,14.162920,0,22.03,0.0,93.4854,313.82,291.79,28.61,'PN40','condotta',''),
(365,42.397670,14.160590,0,20.85,0.0,93.7200,313.76,292.91,28.72,'PN40','condotta',''),
(366,42.395830,14.160820,0,24.06,0.0,93.9254,313.70,289.64,28.40,'PN40','condotta',''),
(367,42.394260,14.162910,0,30.56,0.0,94.1703,313.63,283.07,27.75,'PN40','condotta',''),
(368,42.391900,14.162100,0,42.46,0.0,94.4410,313.56,271.10,26.58,'PN40','condotta',''),
(369,42.389650,14.160190,0,39.06,0.0,94.7363,313.47,274.42,26.90,'PN40','condotta',''),
(370,42.387830,14.158160,0,41.10,0.0,94.9985,313.40,272.30,26.70,'PN40','condotta',''),
(371,42.385810,14.156810,0,41.65,0.0,95.2490,313.33,271.68,26.64,'PN40','condotta',''),
(372,42.383420,14.156350,0,53.55,0.0,95.5174,313.26,259.71,25.46,'PN40','condotta',''),
(373,42.381080,14.156090,0,52.22,0.0,95.7785,313.18,260.96,25.58,'PN40','condotta',''),
(374,42.378470,14.154780,0,49.93,0.0,96.0880,313.10,263.16,25.80,'PN40','condotta',''),
(375,42.376140,14.154000,0,48.15,0.0,96.3549,313.02,264.87,25.97,'PN40','condotta',''),
(376,42.373890,14.153740,0,65.17,0.0,96.6060,312.95,247.78,24.29,'PN25','condotta',''),
(377,42.371540,14.154440,0,57.05,0.0,96.8735,312.88,255.82,25.08,'PN40','condotta',''),
(378,42.369400,14.155460,0,86.10,0.0,97.1258,312.80,226.71,22.23,'PN25','condotta',''),
(379,42.367230,14.156520,0,63.00,0.0,97.3823,312.73,249.73,24.48,'PN25','condotta',''),
(380,42.364660,14.157640,0,102.59,0.0,97.6826,312.65,210.06,20.59,'PN25','condotta',''),
(381,42.362490,14.159060,0,130.42,0.0,97.9506,312.57,182.15,17.86,'PN25','condotta',''),
(382,42.360360,14.159630,0,126.45,0.0,98.1920,312.51,186.05,18.24,'PN25','condotta',''),
(383,42.358790,14.157250,0,118.06,0.0,98.4541,312.43,194.37,19.06,'PN25','condotta',''),
(384,42.358180,14.154360,0,102.40,0.0,98.7011,312.36,209.96,20.58,'PN25','condotta',''),
(385,42.356720,14.155250,0,109.63,0.0,98.8792,312.31,202.69,19.87,'PN25','condotta',''),
(386,42.355230,14.154160,0,130.93,0.0,99.0675,312.26,181.33,17.78,'PN25','condotta',''),
(387,42.354620,14.154860,0,151.93,0.0,99.1564,312.24,160.30,15.72,'PN16','condotta',''),
(388,42.355410,14.157820,0,172.33,0.0,99.4150,312.16,139.84,13.71,'PN16','condotta',''),
(389,42.354310,14.157580,0,192.86,0.0,99.5389,312.13,119.27,11.69,'PN16','condotta',''),
(390,42.353770,14.158390,0,206.56,0.0,99.6286,312.10,105.55,10.35,'PN16','condotta',''),
(391,42.351770,14.159120,0,226.24,0.0,99.8589,312.04,85.80,8.41,'PN16','condotta',''),
(392,42.351370,14.160360,0,237.16,0.0,99.9701,312.01,74.85,7.34,'PN16','condotta',''),
(393,42.349120,14.160310,0,262.39,0.0,100.2203,311.94,49.55,4.86,'PN16','condotta',''),
(394,42.349760,14.162900,0,276.27,0.0,100.4447,311.88,35.61,3.49,'PN16','condotta',''),
(395,42.351120,14.164220,0,281.76,0.0,100.6308,311.82,30.06,2.95,'PN16','condotta',''),
(396,42.352610,14.165580,0,284.76,0.0,100.8307,311.77,27.01,2.65,'PN16','condotta',''),
(397,42.354370,14.163670,0,279.86,0.0,101.0816,311.70,31.84,3.12,'PN16','condotta',''),
(398,42.356000,14.165540,0,275.26,0.0,101.3192,311.63,36.38,3.57,'PN16','condotta',''),
(399,42.357030,14.168310,0,257.34,0.0,101.5740,311.56,54.22,5.32,'PN16','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(400,42.355630,14.170160,0,252.16,0.0,101.7916,311.50,59.34,5.82,'PN16','condotta',''),
(401,42.354150,14.172120,0,258.25,0.0,102.0218,311.43,53.18,5.21,'PN16','condotta',''),
(402,42.353920,14.175170,0,262.91,0.0,102.2738,311.36,48.45,4.75,'PN16','condotta',''),
(403,42.352340,14.176590,0,268.59,0.0,102.4847,311.30,42.71,4.19,'PN16','condotta',''),
(404,42.351560,14.178770,0,265.26,0.0,102.6837,311.25,45.99,4.51,'PN16','condotta',''),
(405,42.351510,14.181910,0,269.76,0.0,102.9418,311.18,41.41,4.06,'PN16','condotta',''),
(406,42.351770,14.184850,0,266.34,0.0,103.1851,311.11,44.77,4.39,'PN16','condotta',''),
(407,42.352140,14.187830,0,233.22,0.0,103.4334,311.04,77.82,7.63,'PN16','condotta',''),
(408,42.351400,14.190590,0,212.82,0.0,103.6747,310.97,98.15,9.62,'PN16','condotta',''),
(409,42.351520,14.193600,0,186.03,0.0,103.9224,310.90,124.87,12.24,'PN16','condotta',''),
(410,42.350660,14.196450,0,149.64,0.0,104.1754,310.83,161.19,15.80,'PN16','condotta',''),
(411,42.350190,14.199360,0,134.90,0.0,104.4202,310.76,175.86,17.24,'PN25','condotta',''),
(412,42.349800,14.202350,0,108.29,0.0,104.6697,310.69,202.40,19.84,'PN25','condotta',''),
(413,42.349290,14.205150,0,77.59,0.0,104.9067,310.63,233.04,22.85,'PN25','condotta',''),
(414,42.349270,14.207970,0,57.58,0.0,105.1384,310.56,252.98,24.80,'PN25','condotta',''),
(415,42.348230,14.210350,0,76.79,0.0,105.3656,310.50,233.71,22.91,'PN25','condotta',''),
(416,42.346420,14.208400,0,83.68,0.0,105.6229,310.43,226.75,22.23,'PN25','condotta',''),
(417,42.344360,14.206520,0,79.51,0.0,105.8992,310.35,230.84,22.63,'PN25','condotta',''),
(418,42.342270,14.205060,0,80.13,0.0,106.1607,310.27,230.14,22.56,'PN25','condotta',''),
(419,42.340340,14.203500,0,85.28,0.0,106.4107,310.20,224.92,22.05,'PN25','condotta',''),
(420,42.338590,14.200820,0,87.00,0.0,106.7046,310.12,223.13,21.88,'PN25','condotta',''),
(421,42.337260,14.198300,0,87.50,0.0,106.9592,310.05,222.55,21.82,'PN25','condotta',''),
(422,42.335790,14.195960,0,87.74,0.0,107.2116,309.98,222.24,21.79,'PN25','condotta',''),
(423,42.333910,14.193240,0,90.31,0.0,107.5176,309.90,219.59,21.53,'PN25','condotta',''),
(424,42.332080,14.191100,0,92.55,0.0,107.7866,309.82,217.27,21.30,'PN25','condotta',''),
(425,42.329890,14.188310,0,100.01,0.0,108.1211,309.73,209.71,20.56,'PN25','condotta',''),
(426,42.327910,14.186340,0,101.81,0.0,108.3945,309.65,207.84,20.38,'PN25','condotta',''),
(427,42.325440,14.185310,0,106.34,0.0,108.6819,309.57,203.23,19.92,'PN25','condotta',''),
(428,42.323040,14.184650,0,108.01,0.0,108.9542,309.49,201.48,19.75,'PN25','condotta',''),
(429,42.320810,14.184010,0,97.40,0.0,109.2077,309.42,212.02,20.79,'PN25','condotta',''),
(430,42.318580,14.183140,0,112.56,0.0,109.4658,309.35,196.79,19.29,'PN25','condotta',''),
(431,42.316950,14.181430,0,112.55,0.0,109.6951,309.29,196.73,19.29,'PN25','condotta',''),
(432,42.318210,14.182540,0,105.99,0.0,109.8623,309.24,203.24,19.93,'PN25','condotta',''),
(433,42.316910,14.183890,0,117.74,0.0,110.0446,309.19,191.45,18.77,'PN25','condotta',''),
(434,42.318870,14.183340,0,114.51,0.0,110.2672,309.13,194.61,19.08,'PN25','condotta',''),
(435,42.321340,14.184170,0,92.80,0.0,110.5502,309.05,216.24,21.20,'PN25','condotta',''),
(436,42.323870,14.184880,0,107.30,0.0,110.8375,308.97,201.66,19.77,'PN25','condotta',''),
(437,42.326150,14.185510,0,106.37,0.0,111.0963,308.89,202.53,19.86,'PN25','condotta',''),
(438,42.328290,14.186630,0,101.31,0.0,111.3514,308.82,207.51,20.34,'PN25','condotta',''),
(439,42.330770,14.189430,0,97.08,0.0,111.7106,308.72,211.65,20.75,'PN25','condotta',''),
(440,42.332550,14.191670,0,91.40,0.0,111.9809,308.65,217.24,21.30,'PN25','condotta',''),
(441,42.334880,14.194630,0,88.89,0.0,112.3364,308.55,219.66,21.54,'PN25','condotta',''),
(442,42.336540,14.197070,0,87.90,0.0,112.6089,308.47,220.57,21.62,'PN25','condotta',''),
(443,42.337990,14.199680,0,85.99,0.0,112.8773,308.39,222.40,21.80,'PN25','condotta',''),
(444,42.339370,14.202230,0,81.05,0.0,113.1371,308.32,227.27,22.28,'PN25','condotta',''),
(445,42.341160,14.204260,0,86.30,0.0,113.3968,308.25,221.95,21.76,'PN25','condotta',''),
(446,42.343170,14.205680,0,86.24,0.0,113.6489,308.18,221.94,21.76,'PN25','condotta',''),
(447,42.345180,14.207200,0,82.97,0.0,113.9050,308.11,225.14,22.07,'PN25','condotta',''),
(448,42.346920,14.209160,0,82.63,0.0,114.1567,308.04,225.41,22.10,'PN25','condotta',''),
(449,42.349010,14.211940,0,81.05,0.0,114.4826,307.94,226.89,22.24,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(450,42.350650,14.214170,0,81.18,0.0,114.7411,307.87,226.69,22.22,'PN25','condotta',''),
(451,42.353010,14.216120,0,76.83,0.0,115.0486,307.79,230.96,22.64,'PN25','condotta',''),
(452,42.355110,14.217250,0,78.00,0.0,115.2999,307.72,229.72,22.52,'PN25','condotta',''),
(453,42.357160,14.219190,0,77.93,0.0,115.5781,307.64,229.70,22.52,'PN25','condotta',''),
(454,42.359000,14.221290,0,77.05,0.0,115.8457,307.56,230.51,22.60,'PN25','condotta',''),
(455,42.360350,14.223750,0,78.05,0.0,116.0975,307.49,229.45,22.49,'PN25','condotta',''),
(456,42.361060,14.226660,0,83.04,0.0,116.3493,307.42,224.38,22.00,'PN25','condotta',''),
(457,42.361540,14.229660,0,93.09,0.0,116.6015,307.35,214.26,21.01,'PN25','condotta',''),
(458,42.360980,14.232430,0,110.52,0.0,116.8374,307.29,196.77,19.29,'PN25','condotta',''),
(459,42.360220,14.229160,0,121.70,0.0,117.1191,307.21,185.51,18.19,'PN25','condotta',''),
(460,42.358810,14.230780,0,140.10,0.0,117.3248,307.15,167.05,16.38,'PN25','condotta',''),
(461,42.358010,14.229870,0,156.86,0.0,117.4410,307.12,150.26,14.73,'PN16','condotta',''),
(462,42.357550,14.228550,0,174.10,0.0,117.5609,307.08,132.98,13.04,'PN16','condotta',''),
(463,42.356570,14.230550,0,193.75,0.0,117.7581,307.03,113.28,11.11,'PN16','condotta',''),
(464,42.356710,14.233300,0,189.65,0.0,117.9846,306.96,117.31,11.50,'PN16','condotta',''),
(465,42.358020,14.235790,0,182.68,0.0,118.2357,306.89,124.22,12.18,'PN16','condotta',''),
(466,42.360080,14.237390,0,176.80,0.0,118.4998,306.82,130.02,12.75,'PN16','condotta',''),
(467,42.362020,14.239150,0,180.83,0.0,118.7595,306.75,125.92,12.34,'PN16','condotta',''),
(468,42.364110,14.241190,0,172.25,0.0,119.0461,306.67,134.42,13.18,'PN16','condotta',''),
(469,42.365270,14.243980,0,166.25,0.0,119.3091,306.59,140.34,13.76,'PN16','condotta',''),
(470,42.366550,14.245940,0,175.69,0.0,119.5240,306.53,130.84,12.83,'PN16','condotta',''),
(471,42.367690,14.248640,0,184.31,0.0,119.7795,306.46,122.15,11.98,'PN16','condotta',''),
(472,42.368700,14.251380,0,187.32,0.0,120.0310,306.39,119.07,11.67,'PN16','condotta',''),
(473,42.369820,14.254060,0,193.92,0.0,120.2840,306.32,112.40,11.02,'PN16','condotta',''),
(474,42.372090,14.255060,0,180.98,0.0,120.5494,306.25,125.27,12.28,'PN16','condotta',''),
(475,42.374260,14.255970,0,166.69,0.0,120.8020,306.18,139.49,13.68,'PN16','condotta',''),
(476,42.376030,14.258110,0,166.73,0.0,121.0659,306.10,139.37,13.66,'PN16','condotta',''),
(477,42.377530,14.260520,0,180.42,0.0,121.3248,306.03,125.60,12.31,'PN16','condotta',''),
(478,42.379280,14.262760,0,177.00,0.0,121.5926,305.95,128.95,12.64,'PN16','condotta',''),
(479,42.380890,14.265100,0,165.24,0.0,121.8553,305.88,140.64,13.79,'PN16','condotta',''),
(480,42.382460,14.267300,0,158.07,0.0,122.1065,305.81,147.74,14.48,'PN16','condotta',''),
(481,42.383960,14.269690,0,150.76,0.0,122.3641,305.74,154.98,15.19,'PN16','condotta',''),
(482,42.385690,14.271670,0,157.43,0.0,122.6160,305.67,148.23,14.53,'PN16','condotta',''),
(483,42.387110,14.274220,0,154.62,0.0,122.8783,305.59,150.97,14.80,'PN16','condotta',''),
(484,42.388920,14.276060,0,145.62,0.0,123.1300,305.52,159.90,15.68,'PN16','condotta',''),
(485,42.391060,14.277570,0,140.27,0.0,123.3983,305.45,165.17,16.19,'PN25','condotta',''),
(486,42.392580,14.279880,0,123.64,0.0,123.6524,305.38,181.73,17.82,'PN25','condotta',''),
(487,42.394090,14.282380,0,103.41,0.0,123.9176,305.30,201.89,19.79,'PN25','condotta',''),
(488,42.395750,14.284450,0,87.30,0.0,124.1685,305.23,217.93,21.37,'PN25','condotta',''),
(489,42.396780,14.287200,0,74.66,0.0,124.4217,305.16,230.50,22.60,'PN25','condotta',''),
(490,42.397490,14.290140,0,70.87,0.0,124.6757,305.09,234.22,22.96,'PN25','condotta',''),
(491,42.398480,14.288470,0,66.47,0.0,124.8516,305.04,238.57,23.39,'PN25','condotta',''),
(492,42.398320,14.285550,0,68.39,0.0,125.0920,304.97,236.59,23.20,'PN25','condotta',''),
(493,42.397970,14.287550,0,69.69,0.0,125.2608,304.93,235.24,23.06,'PN25','condotta',''),
(494,42.395840,14.288690,0,70.06,0.0,125.5155,304.86,234.79,23.02,'PN25','condotta',''),
(495,42.393140,14.288690,0,68.51,0.0,125.8157,304.77,236.26,23.16,'PN25','condotta',''),
(496,42.390680,14.288660,0,68.56,0.0,126.0893,304.70,236.13,23.15,'PN25','condotta',''),
(497,42.387690,14.288600,0,65.02,0.0,126.4218,304.60,239.58,23.49,'PN25','condotta',''),
(498,42.385310,14.288600,0,60.42,0.0,126.6864,304.53,244.10,23.93,'PN25','condotta',''),
(499,42.383140,14.289450,0,55.82,0.0,126.9376,304.46,248.64,24.38,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(500,42.381060,14.291650,0,47.23,0.0,127.2311,304.38,257.14,25.21,'PN40','condotta',''),
(501,42.379280,14.293830,0,42.20,0.0,127.4980,304.30,262.10,25.70,'PN40','condotta',''),
(502,42.377860,14.296340,0,40.74,0.0,127.7577,304.23,263.49,25.83,'PN40','condotta',''),
(503,42.376420,14.300090,0,32.55,0.0,128.1049,304.13,271.58,26.63,'PN40','condotta',''),
(504,42.375360,14.302860,0,21.57,0.0,128.3611,304.06,282.48,27.69,'PN40','condotta',''),
(505,42.373990,14.306490,0,17.02,0.0,128.6960,303.97,286.95,28.13,'PN40','condotta',''),
(506,42.372790,14.309680,0,42.09,0.0,128.9900,303.88,261.79,25.67,'PN40','condotta',''),
(507,42.371990,14.312870,0,84.06,0.0,129.2668,303.81,219.75,21.54,'PN25','condotta',''),
(508,42.370890,14.315620,0,98.96,0.0,129.5237,303.73,204.77,20.08,'PN25','condotta',''),
(509,42.368610,14.318750,0,109.79,0.0,129.8848,303.63,193.84,19.00,'PN25','condotta',''),
(510,42.366840,14.320920,0,119.38,0.0,130.1503,303.56,184.18,18.06,'PN25','condotta',''),
(511,42.365030,14.323080,0,117.26,0.0,130.4187,303.48,186.22,18.26,'PN25','condotta',''),
(512,42.363340,14.325470,0,116.02,0.0,130.6904,303.41,187.39,18.37,'PN25','condotta',''),
(513,42.362370,14.328550,0,114.30,0.0,130.9655,303.33,189.03,18.53,'PN25','condotta',''),
(514,42.361800,14.331560,0,108.65,0.0,131.2208,303.26,194.61,19.08,'PN25','condotta',''),
(515,42.361220,14.334680,0,96.79,0.0,131.4852,303.18,206.40,20.24,'PN25','condotta',''),
(516,42.360600,14.337990,0,55.57,0.0,131.7657,303.11,247.54,24.27,'PN25','condotta',''),
(517,42.359950,14.341440,0,80.06,0.0,132.0583,303.02,222.96,21.86,'PN25','condotta',''),
(518,42.359380,14.344490,0,104.42,0.0,132.3168,302.95,198.53,19.46,'PN25','condotta',''),
(519,42.358720,14.347600,0,105.85,0.0,132.5826,302.88,197.03,19.32,'PN25','condotta',''),
(520,42.357170,14.350100,0,105.47,0.0,132.8508,302.80,197.34,19.35,'PN25','condotta',''),
(521,42.354740,14.351690,0,71.69,0.0,133.1509,302.72,231.03,22.65,'PN25','condotta',''),
(522,42.351830,14.353440,0,101.04,0.0,133.5050,302.62,201.58,19.76,'PN25','condotta',''),
(523,42.348800,14.355260,0,97.28,0.0,133.8736,302.52,205.24,20.12,'PN25','condotta',''),
(524,42.346680,14.356520,0,101.02,0.0,134.1311,302.44,201.43,19.75,'PN25','condotta',''),
(525,42.344500,14.357390,0,107.27,0.0,134.3838,302.37,195.10,19.13,'PN25','condotta',''),
(526,42.342040,14.358000,0,109.47,0.0,134.6619,302.29,192.83,18.90,'PN25','condotta',''),
(527,42.339830,14.358710,0,110.59,0.0,134.9145,302.22,191.63,18.79,'PN25','condotta',''),
(528,42.338040,14.360590,0,110.46,0.0,135.1665,302.15,191.70,18.79,'PN25','condotta',''),
(529,42.336930,14.363360,0,118.36,0.0,135.4255,302.08,183.72,18.01,'PN25','condotta',''),
(530,42.335850,14.366390,0,119.39,0.0,135.7020,302.00,182.61,17.90,'PN25','condotta',''),
(531,42.334840,14.369240,0,119.01,0.0,135.9617,301.93,182.92,17.93,'PN25','condotta',''),
(532,42.333790,14.372210,0,88.60,0.0,136.2324,301.85,213.26,20.91,'PN25','condotta',''),
(533,42.332710,14.375200,0,118.00,0.0,136.5059,301.78,183.78,18.02,'PN25','condotta',''),
(534,42.331730,14.377960,0,115.11,0.0,136.7576,301.71,186.59,18.29,'PN25','condotta',''),
(535,42.330550,14.380510,0,113.59,0.0,137.0049,301.64,188.05,18.44,'PN25','condotta',''),
(536,42.330370,14.382290,0,118.36,0.0,137.1526,301.60,183.24,17.96,'PN25','condotta',''),
(537,42.330270,14.385150,0,108.69,0.0,137.3879,301.53,192.84,18.91,'PN25','condotta',''),
(538,42.330840,14.387330,0,100.67,0.0,137.5780,301.48,200.81,19.69,'PN25','condotta',''),
(539,42.332130,14.389670,0,106.02,0.0,137.8180,301.41,195.40,19.16,'PN25','condotta',''),
(540,42.331020,14.391650,0,108.39,0.0,138.0222,301.35,192.96,18.92,'PN25','condotta',''),
(541,42.329290,14.390060,0,110.03,0.0,138.2548,301.29,191.26,18.75,'PN25','condotta',''),
(542,42.327410,14.387870,0,111.36,0.0,138.5307,301.21,189.85,18.61,'PN25','condotta',''),
(543,42.325660,14.385690,0,117.60,0.0,138.7952,301.14,183.53,17.99,'PN25','condotta',''),
(544,42.324100,14.383290,0,124.95,0.0,139.0579,301.06,176.11,17.27,'PN25','condotta',''),
(545,42.322590,14.380920,0,131.92,0.0,139.3152,300.99,169.07,16.58,'PN25','condotta',''),
(546,42.320690,14.378160,0,138.73,0.0,139.6252,300.90,162.17,15.90,'PN16','condotta',''),
(547,42.318740,14.376570,0,145.17,0.0,139.8784,300.83,155.67,15.26,'PN16','condotta',''),
(548,42.316460,14.374180,0,147.99,0.0,140.1991,300.74,152.75,14.98,'PN16','condotta',''),
(549,42.314480,14.371410,0,152.01,0.0,140.5159,300.66,148.64,14.57,'PN16','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(550,42.312590,14.369640,0,154.84,0.0,140.7716,300.58,145.75,14.29,'PN16','condotta',''),
(551,42.310460,14.368190,0,160.21,0.0,141.0367,300.51,140.30,13.76,'PN16','condotta',''),
(552,42.308380,14.366700,0,167.52,0.0,141.2985,300.44,132.91,13.03,'PN16','condotta',''),
(553,42.306300,14.365200,0,172.35,0.0,141.5606,300.36,128.01,12.55,'PN16','condotta',''),
(554,42.303960,14.363510,0,178.31,0.0,141.8556,300.28,121.97,11.96,'PN16','condotta',''),
(555,42.301870,14.362020,0,180.67,0.0,142.1183,300.21,119.54,11.72,'PN16','condotta',''),
(556,42.299760,14.360530,0,186.64,0.0,142.3830,300.13,113.49,11.13,'PN16','condotta',''),
(557,42.297730,14.358940,0,190.91,0.0,142.6438,300.06,109.15,10.70,'PN16','condotta',''),
(558,42.295530,14.356450,0,195.61,0.0,142.9629,299.97,104.36,10.23,'PN16','condotta',''),
(559,42.294520,14.354000,0,198.40,0.0,143.1936,299.91,101.51,9.95,'PN16','condotta',''),
(560,42.294420,14.351010,0,200.13,0.0,143.4398,299.84,99.70,9.77,'PN16','condotta',''),
(561,42.294830,14.347700,0,206.64,0.0,143.7158,299.76,93.11,9.13,'PN16','condotta',''),
(562,42.295320,14.344980,0,199.28,0.0,143.9461,299.70,100.42,9.84,'PN16','condotta',''),
(563,42.295970,14.342020,0,207.29,0.0,144.2000,299.62,92.33,9.05,'PN16','condotta',''),
(564,42.294260,14.340240,0,212.64,0.0,144.4400,299.56,86.91,8.52,'PN16','condotta',''),
(565,42.291980,14.340330,0,212.45,0.0,144.6936,299.49,87.03,8.53,'PN16','condotta',''),
(566,42.290000,14.341030,0,222.01,0.0,144.9212,299.42,77.41,7.59,'PN16','condotta',''),
(567,42.290600,14.342340,0,219.50,0.0,145.0479,299.39,79.88,7.83,'PN16','condotta',''),
(568,42.289320,14.344910,0,219.28,0.0,145.3028,299.32,80.03,7.85,'PN16','condotta',''),
(569,42.287240,14.345710,0,225.41,0.0,145.5432,299.25,73.84,7.24,'PN16','condotta',''),
(570,42.285070,14.346030,0,230.02,0.0,145.7860,299.18,69.16,6.78,'PN16','condotta',''),
(571,42.282760,14.345560,0,233.02,0.0,146.0457,299.11,66.09,6.48,'PN16','condotta',''),
(572,42.280400,14.344600,0,235.58,0.0,146.3198,299.03,63.45,6.22,'PN16','condotta',''),
(573,42.278480,14.342940,0,239.60,0.0,146.5732,298.96,59.36,5.82,'PN16','condotta',''),
(574,42.276320,14.341060,0,247.55,0.0,146.8589,298.88,51.33,5.03,'PN16','condotta',''),
(575,42.273900,14.338940,0,255.29,0.0,147.1796,298.79,43.50,4.26,'PN16','condotta',''),
(576,42.272030,14.337150,0,260.25,0.0,147.4344,298.72,38.46,3.77,'PN16','condotta',''),
(577,42.271050,14.333960,0,262.94,0.0,147.7186,298.64,35.70,3.50,'PN16','condotta',''),
(578,42.270080,14.330580,0,267.77,0.0,148.0169,298.56,30.79,3.02,'PN16','condotta',''),
(579,42.269060,14.326970,0,274.17,0.0,148.3348,298.47,24.29,2.38,'PN16','condotta',''),
(580,42.267540,14.324430,0,278.91,0.0,148.6036,298.39,19.48,1.91,'PN16','condotta',''),
(581,42.265650,14.322700,0,284.91,0.0,148.8574,298.32,13.41,1.31,'PN16','condotta',''),
(582,42.262490,14.321870,0,291.40,0.0,149.2154,298.22,6.82,0.67,'PN16','condotta',''),
(583,42.260090,14.321200,0,297.05,0.0,149.4879,298.14,1.09,0.11,'PN16','condotta',''),
(584,42.257470,14.319260,0,301.69,0.0,149.8201,298.05,-3.64,0.00,'PN16','galleria','Galleria breve (deficit 4m)'),
(585,42.255490,14.317680,0,309.05,0.0,150.0758,297.98,-11.07,0.00,'PN16','galleria','Galleria breve (deficit 11m)'),
(586,42.254470,14.318780,0,309.41,0.0,150.2209,297.94,-11.48,0.00,'PN16','galleria','Galleria breve (deficit 11m)'),
(587,42.252720,14.320890,0,284.40,0.0,150.4817,297.87,13.47,1.32,'PN16','condotta',''),
(588,42.251270,14.323550,0,259.91,0.0,150.7536,297.79,37.88,3.71,'PN16','condotta',''),
(589,42.250680,14.326730,0,245.54,0.0,151.0235,297.71,52.18,5.12,'PN16','condotta',''),
(590,42.250370,14.330150,0,235.25,0.0,151.3071,297.63,62.38,6.12,'PN16','condotta',''),
(591,42.250610,14.333320,0,228.98,0.0,151.5694,297.56,68.58,6.72,'PN16','condotta',''),
(592,42.251620,14.338430,0,180.34,0.0,152.0047,297.44,117.10,11.48,'PN16','condotta',''),
(593,42.252110,14.341540,0,152.57,0.0,152.2664,297.37,144.80,14.20,'PN16','condotta',''),
(594,42.252400,14.344440,0,125.49,0.0,152.5072,297.30,171.80,16.84,'PN25','condotta',''),
(595,42.250880,14.346980,0,112.38,0.0,152.7761,297.22,184.85,18.12,'PN25','condotta',''),
(596,42.250880,14.349910,0,131.15,0.0,153.0172,297.16,166.00,16.27,'PN25','condotta',''),
(597,42.250160,14.352670,0,142.43,0.0,153.2581,297.09,154.65,15.16,'PN16','condotta',''),
(598,42.251590,14.355040,0,150.51,0.0,153.5098,297.02,146.51,14.36,'PN16','condotta',''),
(599,42.252170,14.356910,0,167.61,0.0,153.6766,296.97,129.36,12.68,'PN16','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(600,42.250940,14.359120,0,184.65,0.0,153.9042,296.91,112.26,11.01,'PN16','condotta',''),
(601,42.251730,14.361110,0,204.79,0.0,154.0901,296.85,92.07,9.03,'PN16','condotta',''),
(602,42.249530,14.361060,0,226.58,0.0,154.3347,296.79,70.21,6.88,'PN16','condotta',''),
(603,42.247290,14.362720,0,259.77,0.0,154.6188,296.71,36.93,3.62,'PN16','condotta',''),
(604,42.246070,14.365340,0,252.37,0.0,154.8736,296.64,44.26,4.34,'PN16','condotta',''),
(605,42.244940,14.368120,0,232.36,0.0,155.1347,296.56,64.21,6.29,'PN16','condotta',''),
(606,42.243340,14.370200,0,217.64,0.0,155.3816,296.49,78.86,7.73,'PN16','condotta',''),
(607,42.242590,14.370880,0,202.07,0.0,155.4820,296.47,94.40,9.25,'PN16','condotta',''),
(608,42.244660,14.371720,0,186.12,0.0,155.7224,296.40,110.28,10.81,'PN16','condotta',''),
(609,42.246480,14.373370,0,170.77,0.0,155.9661,296.33,125.56,12.31,'PN16','condotta',''),
(610,42.244880,14.374980,0,139.45,0.0,156.1879,296.27,156.81,15.37,'PN16','condotta',''),
(611,42.244580,14.378230,0,122.11,0.0,156.4575,296.19,174.08,17.07,'PN25','condotta',''),
(612,42.244390,14.380770,0,130.24,0.0,156.6677,296.13,165.89,16.26,'PN25','condotta',''),
(613,42.244110,14.382770,0,145.79,0.0,156.8352,296.09,150.29,14.73,'PN16','condotta',''),
(614,42.241970,14.382220,0,161.42,0.0,157.0775,296.02,134.60,13.20,'PN16','condotta',''),
(615,42.241200,14.384630,0,175.07,0.0,157.2935,295.96,120.89,11.85,'PN16','condotta',''),
(616,42.238930,14.384460,0,187.87,0.0,157.5463,295.89,108.02,10.59,'PN16','condotta',''),
(617,42.236650,14.385860,0,205.05,0.0,157.8248,295.81,90.76,8.90,'PN16','condotta',''),
(618,42.235630,14.387320,0,221.15,0.0,157.9901,295.76,74.61,7.31,'PN16','condotta',''),
(619,42.235070,14.388630,0,231.48,0.0,158.1146,295.73,64.25,6.30,'PN16','condotta',''),
(620,42.233290,14.389600,0,250.55,0.0,158.3281,295.67,45.12,4.42,'PN16','condotta',''),
(621,42.234710,14.391960,0,240.87,0.0,158.5784,295.60,54.73,5.37,'PN16','condotta',''),
(622,42.234870,14.390970,0,232.41,0.0,158.6618,295.57,63.17,6.19,'PN16','condotta',''),
(623,42.234670,14.392460,0,240.16,0.0,158.7865,295.54,55.38,5.43,'PN16','condotta',''),
(624,42.233310,14.393780,0,239.12,0.0,158.9727,295.49,56.36,5.53,'PN16','condotta',''),
(625,42.233610,14.395310,0,244.87,0.0,159.1030,295.45,50.58,4.96,'PN16','condotta',''),
(626,42.232340,14.394130,0,253.41,0.0,159.2745,295.40,41.99,4.12,'PN16','condotta',''),
(627,42.230210,14.396000,0,273.95,0.0,159.5569,295.32,21.38,2.10,'PN16','condotta',''),
(628,42.229310,14.395890,0,273.24,0.0,159.6574,295.30,22.06,2.16,'PN16','condotta',''),
(629,42.227880,14.398180,0,270.24,0.0,159.9041,295.23,24.99,2.45,'PN16','condotta',''),
(630,42.229080,14.400020,0,253.66,0.0,160.1060,295.17,41.51,4.07,'PN16','condotta',''),
(631,42.228390,14.402110,0,238.49,0.0,160.2944,295.12,56.63,5.55,'PN16','condotta',''),
(632,42.229350,14.403210,0,233.20,0.0,160.4344,295.08,61.88,6.07,'PN16','condotta',''),
(633,42.231220,14.404780,0,245.05,0.0,160.6792,295.01,49.96,4.90,'PN16','condotta',''),
(634,42.233390,14.405740,0,257.22,0.0,160.9331,294.94,37.72,3.70,'PN16','condotta',''),
(635,42.235420,14.407560,0,251.75,0.0,161.2040,294.86,43.11,4.23,'PN16','condotta',''),
(636,42.237350,14.409140,0,248.01,0.0,161.4550,294.79,46.78,4.59,'PN16','condotta',''),
(637,42.239590,14.409770,0,243.17,0.0,161.7094,294.72,51.55,5.05,'PN16','condotta',''),
(638,42.241480,14.411190,0,240.23,0.0,161.9499,294.65,54.42,5.34,'PN16','condotta',''),
(639,42.243060,14.413680,0,238.19,0.0,162.2199,294.58,56.39,5.53,'PN16','condotta',''),
(640,42.245110,14.415660,0,231.56,0.0,162.5001,294.50,62.94,6.17,'PN16','condotta',''),
(641,42.246610,14.418210,0,223.68,0.0,162.7682,294.42,70.75,6.94,'PN16','condotta',''),
(642,42.248130,14.420240,0,218.63,0.0,163.0058,294.36,75.72,7.42,'PN16','condotta',''),
(643,42.250050,14.423310,0,211.09,0.0,163.3366,294.27,83.18,8.15,'PN16','condotta',''),
(644,42.251630,14.425510,0,200.63,0.0,163.5889,294.20,93.57,9.17,'PN16','condotta',''),
(645,42.253330,14.427480,0,195.96,0.0,163.8380,294.13,98.17,9.62,'PN16','condotta',''),
(646,42.256180,14.428830,0,192.69,0.0,164.1738,294.03,101.35,9.94,'PN16','condotta',''),
(647,42.258990,14.429790,0,189.32,0.0,164.4961,293.94,104.63,10.26,'PN16','condotta',''),
(648,42.262070,14.430960,0,182.53,0.0,164.8519,293.84,111.31,10.91,'PN16','condotta',''),
(649,42.264250,14.431790,0,177.26,0.0,165.1037,293.77,116.52,11.42,'PN16','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(650,42.266410,14.432740,0,173.11,0.0,165.3563,293.70,120.59,11.82,'PN16','condotta',''),
(651,42.268430,14.433880,0,169.53,0.0,165.5997,293.63,124.11,12.17,'PN16','condotta',''),
(652,42.270530,14.434460,0,158.14,0.0,165.8380,293.57,135.42,13.28,'PN16','condotta',''),
(653,42.269510,14.436540,0,163.59,0.0,166.0434,293.51,129.92,12.74,'PN16','condotta',''),
(654,42.267800,14.434940,0,164.22,0.0,166.2746,293.44,129.22,12.67,'PN16','condotta',''),
(655,42.266400,14.437240,0,163.91,0.0,166.5197,293.37,129.46,12.69,'PN16','condotta',''),
(656,42.264450,14.439290,0,144.91,0.0,166.7944,293.30,148.38,14.55,'PN16','condotta',''),
(657,42.262150,14.441750,0,161.80,0.0,167.1206,293.21,131.40,12.88,'PN16','condotta',''),
(658,42.260280,14.443700,0,153.74,0.0,167.3832,293.13,139.40,13.67,'PN16','condotta',''),
(659,42.258390,14.445720,0,160.88,0.0,167.6512,293.06,132.18,12.96,'PN16','condotta',''),
(660,42.256450,14.447760,0,162.09,0.0,167.9245,292.98,130.90,12.83,'PN16','condotta',''),
(661,42.254420,14.449910,0,163.82,0.0,168.2114,292.90,129.08,12.65,'PN16','condotta',''),
(662,42.252610,14.451830,0,143.15,0.0,168.4672,292.83,149.68,14.67,'PN16','condotta',''),
(663,42.250670,14.453870,0,166.16,0.0,168.7406,292.75,126.59,12.41,'PN16','condotta',''),
(664,42.248870,14.455740,0,164.11,0.0,168.9931,292.68,128.58,12.61,'PN16','condotta',''),
(665,42.246950,14.457770,0,163.81,0.0,169.2642,292.61,128.80,12.63,'PN16','condotta',''),
(666,42.245200,14.460030,0,164.49,0.0,169.5334,292.53,128.04,12.55,'PN16','condotta',''),
(667,42.243970,14.463380,0,134.77,0.0,169.8412,292.44,157.67,15.46,'PN16','condotta',''),
(668,42.243020,14.466670,0,161.62,0.0,170.1319,292.36,130.75,12.82,'PN16','condotta',''),
(669,42.242120,14.469660,0,161.78,0.0,170.3976,292.29,130.51,12.79,'PN16','condotta',''),
(670,42.241120,14.472620,0,160.67,0.0,170.6655,292.21,131.54,12.90,'PN16','condotta',''),
(671,42.239470,14.474690,0,151.92,0.0,170.9159,292.14,140.23,13.75,'PN16','condotta',''),
(672,42.237350,14.475640,0,140.45,0.0,171.1642,292.07,151.62,14.86,'PN16','condotta',''),
(673,42.234450,14.475580,0,118.42,0.0,171.4867,291.98,173.56,17.02,'PN25','condotta',''),
(674,42.232210,14.475700,0,106.27,0.0,171.7360,291.91,185.64,18.20,'PN25','condotta',''),
(675,42.230000,14.476540,0,100.94,0.0,171.9913,291.84,190.90,18.72,'PN25','condotta',''),
(676,42.227720,14.478320,0,81.03,0.0,172.2841,291.76,210.73,20.66,'PN25','condotta',''),
(677,42.225720,14.480120,0,72.84,0.0,172.5514,291.69,218.85,21.46,'PN25','condotta',''),
(678,42.223680,14.481920,0,66.27,0.0,172.8223,291.61,225.34,22.09,'PN25','condotta',''),
(679,42.221630,14.483720,0,59.19,0.0,173.0942,291.53,232.34,22.78,'PN25','condotta',''),
(680,42.219270,14.485810,0,51.14,0.0,173.4081,291.45,240.31,23.56,'PN25','condotta',''),
(681,42.217320,14.487530,0,45.42,0.0,173.6671,291.37,245.96,24.11,'PN25','condotta',''),
(682,42.215400,14.489220,0,39.30,0.0,173.9219,291.30,252.00,24.71,'PN25','condotta',''),
(683,42.213300,14.491040,0,30.72,0.0,174.1994,291.22,260.51,25.54,'PN40','condotta',''),
(684,42.211310,14.492840,0,21.16,0.0,174.4657,291.15,269.99,26.47,'PN40','condotta',''),
(685,42.209290,14.494610,0,19.99,0.0,174.7335,291.07,271.09,26.58,'PN40','condotta',''),
(686,42.207340,14.496320,0,25.10,0.0,174.9921,291.00,265.90,26.07,'PN40','condotta',''),
(687,42.205300,14.498120,0,25.37,0.0,175.2631,290.93,265.55,26.03,'PN40','condotta',''),
(688,42.203230,14.499940,0,25.94,0.0,175.5377,290.85,264.91,25.97,'PN40','condotta',''),
(689,42.201350,14.501620,0,20.49,0.0,175.7884,290.78,270.29,26.50,'PN40','condotta',''),
(690,42.199670,14.503740,0,19.42,0.0,176.0442,290.71,271.29,26.60,'PN40','condotta',''),
(691,42.198650,14.506490,0,26.20,0.0,176.2975,290.64,264.44,25.93,'PN40','condotta',''),
(692,42.198430,14.509510,0,26.18,0.0,176.5475,290.57,264.39,25.92,'PN40','condotta',''),
(693,42.199010,14.512430,0,43.70,0.0,176.7965,290.50,246.80,24.20,'PN25','condotta',''),
(694,42.200230,14.514980,0,55.02,0.0,177.0466,290.43,235.41,23.08,'PN25','condotta',''),
(695,42.201680,14.517720,0,70.57,0.0,177.3239,290.35,219.78,21.55,'PN25','condotta',''),
(696,42.203050,14.520280,0,82.41,0.0,177.5841,290.28,207.86,20.38,'PN25','condotta',''),
(697,42.204370,14.522750,0,91.22,0.0,177.8349,290.21,198.98,19.51,'PN25','condotta',''),
(698,42.205310,14.525480,0,94.27,0.0,178.0829,290.14,195.87,19.20,'PN25','condotta',''),
(699,42.205170,14.528580,0,87.51,0.0,178.3387,290.07,202.56,19.86,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(700,42.204630,14.531630,0,76.79,0.0,178.5970,289.99,213.20,20.90,'PN25','condotta',''),
(701,42.204450,14.535020,0,65.45,0.0,178.8770,289.91,224.46,22.01,'PN25','condotta',''),
(702,42.204560,14.538170,0,49.92,0.0,179.1367,289.84,239.92,23.52,'PN25','condotta',''),
(703,42.204660,14.541300,0,42.32,0.0,179.3948,289.77,247.45,24.26,'PN25','condotta',''),
(704,42.204790,14.545200,0,36.39,0.0,179.7163,289.68,253.29,24.83,'PN25','condotta',''),
(705,42.204880,14.548240,0,42.40,0.0,179.9669,289.61,247.21,24.24,'PN25','condotta',''),
(706,42.204540,14.551210,0,47.30,0.0,180.2144,289.54,242.24,23.75,'PN25','condotta',''),
(707,42.203360,14.554340,0,42.62,0.0,180.5037,289.46,246.84,24.20,'PN25','condotta',''),
(708,42.202140,14.557480,0,36.25,0.0,180.7958,289.38,253.12,24.82,'PN25','condotta',''),
(709,42.200980,14.560490,0,29.87,0.0,181.0753,289.30,259.43,25.43,'PN40','condotta',''),
(710,42.199870,14.563350,0,34.11,0.0,181.3412,289.22,255.11,25.01,'PN40','condotta',''),
(711,42.198580,14.566650,0,43.07,0.0,181.6486,289.14,246.07,24.12,'PN25','condotta',''),
(712,42.197520,14.569510,0,55.69,0.0,181.9120,289.06,233.38,22.88,'PN25','condotta',''),
(713,42.196920,14.572490,0,60.76,0.0,182.1664,288.99,228.23,22.38,'PN25','condotta',''),
(714,42.196520,14.575560,0,63.89,0.0,182.4232,288.92,225.03,22.06,'PN25','condotta',''),
(715,42.196050,14.579050,0,63.48,0.0,182.7154,288.84,225.36,22.09,'PN25','condotta',''),
(716,42.195600,14.582410,0,59.09,0.0,182.9967,288.76,229.67,22.52,'PN25','condotta',''),
(717,42.195320,14.585530,0,73.98,0.0,183.2556,288.69,214.70,21.05,'PN25','condotta',''),
(718,42.195300,14.588860,0,77.22,0.0,183.5299,288.61,211.39,20.72,'PN25','condotta',''),
(719,42.194850,14.591930,0,80.42,0.0,183.7877,288.54,208.12,20.40,'PN25','condotta',''),
(720,42.193370,14.594330,0,83.69,0.0,184.0450,288.47,204.78,20.08,'PN25','condotta',''),
(721,42.191240,14.596900,0,63.58,0.0,184.3627,288.38,224.79,22.04,'PN25','condotta',''),
(722,42.189190,14.599400,0,85.24,0.0,184.6699,288.29,203.05,19.91,'PN25','condotta',''),
(723,42.186450,14.602720,0,87.66,0.0,185.0793,288.18,200.52,19.66,'PN25','condotta',''),
(724,42.184610,14.604580,0,89.44,0.0,185.3350,288.11,198.66,19.48,'PN25','condotta',''),
(725,42.182280,14.605680,0,93.29,0.0,185.6094,288.03,194.74,19.09,'PN25','condotta',''),
(726,42.179810,14.606490,0,92.92,0.0,185.8921,287.95,195.03,19.12,'PN25','condotta',''),
(727,42.177340,14.607300,0,93.48,0.0,186.1747,287.87,194.39,19.06,'PN25','condotta',''),
(728,42.175000,14.608110,0,82.43,0.0,186.4434,287.80,205.37,20.13,'PN25','condotta',''),
(729,42.173200,14.609850,0,99.82,0.0,186.6896,287.73,187.91,18.42,'PN25','condotta',''),
(730,42.172340,14.612700,0,73.49,0.0,186.9432,287.66,214.16,21.00,'PN25','condotta',''),
(731,42.171570,14.615950,0,100.14,0.0,187.2243,287.58,187.44,18.38,'PN25','condotta',''),
(732,42.170820,14.619170,0,101.57,0.0,187.5025,287.50,185.93,18.23,'PN25','condotta',''),
(733,42.170140,14.622060,0,102.00,0.0,187.7524,287.43,185.42,18.18,'PN25','condotta',''),
(734,42.168850,14.624750,0,95.63,0.0,188.0164,287.36,191.73,18.80,'PN25','condotta',''),
(735,42.167060,14.626680,0,86.92,0.0,188.2712,287.28,200.37,19.64,'PN25','condotta',''),
(736,42.165290,14.628680,0,63.71,0.0,188.5279,287.21,223.50,21.91,'PN25','condotta',''),
(737,42.163600,14.631220,0,66.17,0.0,188.8093,287.13,220.96,21.66,'PN25','condotta',''),
(738,42.162090,14.634180,0,53.20,0.0,189.1054,287.05,233.85,22.93,'PN25','condotta',''),
(739,42.160740,14.636840,0,41.92,0.0,189.3711,286.98,245.06,24.03,'PN25','condotta',''),
(740,42.159270,14.639100,0,30.88,0.0,189.6190,286.91,256.03,25.10,'PN40','condotta',''),
(741,42.159170,14.640690,0,25.41,0.0,189.7505,286.87,261.46,25.63,'PN40','condotta',''),
(742,42.161190,14.640760,0,23.48,0.0,189.9752,286.81,263.33,25.82,'PN40','condotta',''),
(743,42.163200,14.640400,0,20.71,0.0,190.2007,286.74,266.03,26.08,'PN40','condotta',''),
(744,42.163940,14.642740,0,21.42,0.0,190.4103,286.69,265.26,26.01,'PN40','condotta',''),
(745,42.164020,14.645860,0,22.73,0.0,190.6676,286.61,263.88,25.87,'PN40','condotta',''),
(746,42.163770,14.648880,0,25.04,0.0,190.9181,286.54,261.51,25.64,'PN40','condotta',''),
(747,42.164320,14.652000,0,38.32,0.0,191.1824,286.47,248.15,24.33,'PN25','condotta',''),
(748,42.166430,14.654190,0,59.59,0.0,191.4784,286.39,226.79,22.23,'PN25','condotta',''),
(749,42.167660,14.656650,0,73.21,0.0,191.7230,286.32,213.11,20.89,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(750,42.167240,14.659590,0,76.61,0.0,191.9698,286.25,209.64,20.55,'PN25','condotta',''),
(751,42.166190,14.662150,0,75.38,0.0,192.2109,286.18,210.80,20.67,'PN25','condotta',''),
(752,42.164140,14.659270,0,88.05,0.0,192.5400,286.09,198.04,19.42,'PN25','condotta',''),
(753,42.162250,14.657930,0,90.97,0.0,192.7774,286.02,195.06,19.12,'PN25','condotta',''),
(754,42.160010,14.657880,0,98.41,0.0,193.0265,285.95,187.54,18.39,'PN25','condotta',''),
(755,42.158080,14.655830,0,113.24,0.0,193.2997,285.88,172.63,16.92,'PN25','condotta',''),
(756,42.155910,14.655490,0,120.12,0.0,193.5426,285.81,165.69,16.24,'PN25','condotta',''),
(757,42.153460,14.656510,0,125.95,0.0,193.8277,285.73,159.78,15.66,'PN16','condotta',''),
(758,42.151110,14.657490,0,130.62,0.0,194.1012,285.65,155.03,15.20,'PN16','condotta',''),
(759,42.148710,14.658340,0,134.03,0.0,194.3771,285.57,151.55,14.86,'PN16','condotta',''),
(760,42.146120,14.659000,0,135.37,0.0,194.6702,285.49,150.12,14.72,'PN16','condotta',''),
(761,42.143910,14.659600,0,140.06,0.0,194.9209,285.42,145.36,14.25,'PN16','condotta',''),
(762,42.141640,14.660580,0,141.53,0.0,195.1859,285.35,143.82,14.10,'PN16','condotta',''),
(763,42.139390,14.661560,0,144.33,0.0,195.4488,285.27,140.95,13.82,'PN16','condotta',''),
(764,42.137130,14.662000,0,147.59,0.0,195.7027,285.20,137.62,13.49,'PN16','condotta',''),
(765,42.135360,14.663660,0,145.53,0.0,195.9425,285.14,139.61,13.69,'PN16','condotta',''),
(766,42.133630,14.665910,0,155.07,0.0,196.2097,285.06,129.99,12.74,'PN16','condotta',''),
(767,42.131800,14.667830,0,165.29,0.0,196.4675,284.99,119.70,11.74,'PN16','condotta',''),
(768,42.129850,14.669840,0,163.79,0.0,196.7405,284.91,121.12,11.87,'PN16','condotta',''),
(769,42.127680,14.671620,0,164.72,0.0,197.0229,284.83,120.11,11.78,'PN16','condotta',''),
(770,42.125730,14.673220,0,167.53,0.0,197.2767,284.76,117.23,11.49,'PN16','condotta',''),
(771,42.123260,14.675110,0,171.89,0.0,197.5925,284.67,112.78,11.06,'PN16','condotta',''),
(772,42.120700,14.677000,0,177.42,0.0,197.9171,284.58,107.16,10.51,'PN16','condotta',''),
(773,42.118610,14.678170,0,181.82,0.0,198.1687,284.51,102.69,10.07,'PN16','condotta',''),
(774,42.116130,14.679210,0,185.67,0.0,198.4575,284.43,98.76,9.68,'PN16','condotta',''),
(775,42.113740,14.680070,0,191.40,0.0,198.7326,284.35,92.95,9.11,'PN16','condotta',''),
(776,42.111540,14.681150,0,187.62,0.0,198.9929,284.28,96.66,9.48,'PN16','condotta',''),
(777,42.109330,14.681930,0,177.39,0.0,199.2469,284.21,106.82,10.47,'PN16','condotta',''),
(778,42.107310,14.683180,0,165.42,0.0,199.4941,284.14,118.72,11.64,'PN16','condotta',''),
(779,42.105630,14.685290,0,162.70,0.0,199.7494,284.07,121.37,11.90,'PN16','condotta',''),
(780,42.103900,14.687240,0,174.45,0.0,200.0002,284.00,109.55,10.74,'PN16','condotta',''),
(781,42.102300,14.689400,0,181.69,0.0,200.2520,283.93,102.24,10.02,'PN16','condotta',''),
(782,42.104300,14.689210,0,193.01,0.0,200.4749,283.87,90.85,8.91,'PN16','condotta',''),
(783,42.105740,14.691420,0,200.11,0.0,200.7176,283.80,83.69,8.20,'PN16','condotta',''),
(784,42.106070,14.694550,0,187.43,0.0,200.9784,283.73,96.30,9.44,'PN16','condotta',''),
(785,42.106530,14.697650,0,180.63,0.0,201.2392,283.65,103.03,10.10,'PN16','condotta',''),
(786,42.106940,14.700940,0,158.95,0.0,201.5144,283.58,124.63,12.22,'PN16','condotta',''),
(787,42.107710,14.703090,0,157.21,0.0,201.7114,283.52,126.31,12.38,'PN16','condotta',''),
(788,42.110010,14.702950,0,163.51,0.0,201.9674,283.45,119.94,11.76,'PN16','condotta',''),
(789,42.109990,14.705510,0,160.09,0.0,202.1786,283.39,123.30,12.09,'PN16','condotta',''),
(790,42.111240,14.707580,0,146.81,0.0,202.3987,283.33,136.52,13.38,'PN16','condotta',''),
(791,42.113450,14.708170,0,133.81,0.0,202.6493,283.26,149.45,14.65,'PN16','condotta',''),
(792,42.115370,14.709470,0,119.03,0.0,202.8882,283.19,164.16,16.09,'PN25','condotta',''),
(793,42.115410,14.712260,0,114.03,0.0,203.1183,283.13,169.10,16.58,'PN25','condotta',''),
(794,42.115210,14.714450,0,95.56,0.0,203.3003,283.08,187.52,18.38,'PN25','condotta',''),
(795,42.112950,14.714050,0,79.66,0.0,203.5538,283.00,203.34,19.94,'PN25','condotta',''),
(796,42.110710,14.714210,0,65.36,0.0,203.8032,282.94,217.57,21.33,'PN25','condotta',''),
(797,42.108490,14.713290,0,52.51,0.0,204.0615,282.86,230.35,22.58,'PN25','condotta',''),
(798,42.106190,14.714100,0,35.67,0.0,204.3258,282.79,247.12,24.23,'PN25','condotta',''),
(799,42.103970,14.715230,0,24.19,0.0,204.5897,282.71,258.53,25.35,'PN40','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(800,42.101790,14.716280,0,18.72,0.0,204.8471,282.64,263.93,25.88,'PN40','condotta',''),
(801,42.099820,14.717460,0,12.36,0.0,205.0868,282.58,270.21,26.49,'PN40','condotta',''),
(802,42.097740,14.718750,0,11.60,0.0,205.3414,282.50,270.90,26.56,'PN40','condotta',''),
(803,42.095710,14.720200,0,19.09,0.0,205.5969,282.43,263.34,25.82,'PN40','condotta',''),
(804,42.094890,14.723040,0,6.37,0.0,205.8483,282.36,276.00,27.06,'PN40','condotta',''),
(805,42.093610,14.725650,0,4.38,0.0,206.1065,282.29,277.91,27.25,'PN40','condotta',''),
(806,42.092030,14.727900,0,3.52,0.0,206.3621,282.22,278.70,27.32,'PN40','condotta',''),
(807,42.090370,14.730080,0,3.51,0.0,206.6198,282.15,278.63,27.32,'PN40','condotta',''),
(808,42.088640,14.732420,0,4.32,0.0,206.8924,282.07,277.75,27.23,'PN40','condotta',''),
(809,42.087150,14.734720,0,3.84,0.0,207.1443,282.00,278.16,27.27,'PN40','condotta',''),
(810,42.085320,14.737550,0,4.00,0.0,207.4541,281.91,277.92,27.25,'PN40','condotta',''),
(811,42.083740,14.739990,0,2.36,0.0,207.7213,281.84,279.47,27.40,'PN40','condotta',''),
(812,42.082220,14.742200,0,3.43,0.0,207.9699,281.77,278.34,27.29,'PN40','condotta',''),
(813,42.080800,14.744760,0,2.97,0.0,208.2337,281.69,278.73,27.33,'PN40','condotta',''),
(814,42.079020,14.747770,0,3.71,0.0,208.5513,281.61,277.89,27.24,'PN40','condotta',''),
(815,42.077570,14.750370,0,6.63,0.0,208.8197,281.53,274.90,26.95,'PN40','condotta',''),
(816,42.076150,14.752600,0,4.90,0.0,209.0622,281.46,276.56,27.11,'PN40','condotta',''),
(817,42.074820,14.755270,0,3.49,0.0,209.3276,281.39,277.89,27.24,'PN40','condotta',''),
(818,42.073490,14.757760,0,4.21,0.0,209.5808,281.32,277.11,27.17,'PN40','condotta',''),
(819,42.072200,14.761020,0,3.06,0.0,209.8857,281.23,278.18,27.27,'PN40','condotta',''),
(820,42.071000,14.764100,0,2.62,0.0,210.1729,281.15,278.53,27.31,'PN40','condotta',''),
(821,42.069680,14.767380,0,6.52,0.0,210.4808,281.07,274.54,26.92,'PN40','condotta',''),
(822,42.068600,14.770220,0,4.14,0.0,210.7442,280.99,276.85,27.14,'PN40','condotta',''),
(823,42.067520,14.772940,0,4.16,0.0,210.9988,280.92,276.76,27.13,'PN40','condotta',''),
(824,42.066490,14.775490,0,3.65,0.0,211.2385,280.85,277.20,27.18,'PN40','condotta',''),
(825,42.064820,14.779700,0,3.77,0.0,211.6325,280.74,276.97,27.15,'PN40','condotta',''),
(826,42.063630,14.782730,0,2.11,0.0,211.9155,280.66,278.56,27.31,'PN40','condotta',''),
(827,42.062160,14.786440,0,2.55,0.0,212.2626,280.57,278.01,27.26,'PN40','condotta',''),
(828,42.061030,14.789320,0,4.56,0.0,212.5316,280.49,275.93,27.05,'PN40','condotta',''),
(829,42.060160,14.792130,0,3.14,0.0,212.7829,280.42,277.28,27.18,'PN40','condotta',''),
(830,42.059290,14.795030,0,1.82,0.0,213.0411,280.35,278.53,27.31,'PN40','condotta',''),
(831,42.058410,14.797950,0,4.50,0.0,213.3013,280.28,275.77,27.04,'PN40','condotta',''),
(832,42.057370,14.801410,0,5.10,0.0,213.6095,280.19,275.09,26.97,'PN40','condotta',''),
(833,42.056140,14.803960,0,2.27,0.0,213.8605,280.12,277.84,27.24,'PN40','condotta',''),
(834,42.054680,14.806640,0,2.37,0.0,214.1349,280.04,277.67,27.22,'PN40','condotta',''),
(835,42.053260,14.809230,0,3.49,0.0,214.4008,279.97,276.48,27.11,'PN40','condotta',''),
(836,42.050850,14.813620,0,3.10,0.0,214.8515,279.84,276.75,27.13,'PN40','condotta',''),
(837,42.049360,14.816350,0,3.55,0.0,215.1313,279.76,276.21,27.08,'PN40','condotta',''),
(838,42.047930,14.818970,0,3.52,0.0,215.3998,279.69,276.17,27.08,'PN40','condotta',''),
(839,42.046360,14.821840,0,3.15,0.0,215.6941,279.61,276.45,27.10,'PN40','condotta',''),
(840,42.045000,14.824280,0,5.17,0.0,215.9460,279.54,274.37,26.90,'PN40','condotta',''),
(841,42.042970,14.828010,0,4.37,0.0,216.3279,279.43,275.05,26.97,'PN40','condotta',''),
(842,42.041420,14.831900,0,4.47,0.0,216.6925,279.33,274.86,26.95,'PN40','condotta',''),
(843,42.040360,14.835060,0,4.44,0.0,216.9788,279.25,274.81,26.94,'PN40','condotta',''),
(844,42.039030,14.839060,0,3.40,0.0,217.3407,279.14,275.74,27.03,'PN40','condotta',''),
(845,42.038020,14.842070,0,3.91,0.0,217.6135,279.07,275.15,26.98,'PN40','condotta',''),
(846,42.036710,14.845200,0,5.89,0.0,217.9102,278.99,273.09,26.77,'PN40','condotta',''),
(847,42.035500,14.848050,0,4.97,0.0,218.1813,278.91,273.94,26.86,'PN40','condotta',''),
(848,42.034310,14.850780,0,4.38,0.0,218.4427,278.84,274.45,26.91,'PN40','condotta',''),
(849,42.033250,14.854150,0,4.30,0.0,218.7450,278.75,274.45,26.91,'PN40','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(850,42.032410,14.857570,0,4.45,0.0,219.0425,278.67,274.21,26.88,'PN40','condotta',''),
(851,42.031670,14.860600,0,5.28,0.0,219.3059,278.59,273.31,26.80,'PN40','condotta',''),
(852,42.030690,14.864650,0,11.84,0.0,219.6577,278.50,266.66,26.14,'PN40','condotta',''),
(853,42.030000,14.867560,0,14.72,0.0,219.9100,278.43,263.71,25.85,'PN40','condotta',''),
(854,42.029280,14.870510,0,14.12,0.0,220.1665,278.35,264.23,25.91,'PN40','condotta',''),
(855,42.028380,14.873760,0,12.33,0.0,220.4530,278.27,265.94,26.07,'PN40','condotta',''),
(856,42.027330,14.877200,0,9.11,0.0,220.7602,278.19,269.08,26.38,'PN40','condotta',''),
(857,42.026040,14.881280,0,5.76,0.0,221.1265,278.08,272.32,26.70,'PN40','condotta',''),
(858,42.025150,14.884280,0,9.88,0.0,221.3933,278.01,268.13,26.29,'PN40','condotta',''),
(859,42.024230,14.887340,0,15.16,0.0,221.6660,277.93,262.78,25.76,'PN40','condotta',''),
(860,42.023250,14.890480,0,11.58,0.0,221.9473,277.85,266.27,26.10,'PN40','condotta',''),
(861,42.022250,14.893700,0,8.11,0.0,222.2356,277.77,269.66,26.44,'PN40','condotta',''),
(862,42.021490,14.896610,0,5.24,0.0,222.4904,277.70,272.46,26.71,'PN40','condotta',''),
(863,42.019990,14.898890,0,9.71,0.0,222.7420,277.63,267.92,26.27,'PN40','condotta',''),
(864,42.018820,14.901690,0,14.23,0.0,223.0074,277.56,263.33,25.82,'PN40','condotta',''),
(865,42.018300,14.904680,0,19.59,0.0,223.2610,277.49,257.89,25.28,'PN40','condotta',''),
(866,42.017210,14.907790,0,21.75,0.0,223.5451,277.41,255.65,25.06,'PN40','condotta',''),
(867,42.015690,14.910010,0,21.83,0.0,223.7945,277.34,255.50,25.05,'PN40','condotta',''),
(868,42.015090,14.913070,0,24.16,0.0,224.0560,277.26,253.10,24.81,'PN25','condotta',''),
(869,42.015100,14.916260,0,22.60,0.0,224.3195,277.19,254.59,24.96,'PN25','condotta',''),
(870,42.014730,14.919470,0,26.49,0.0,224.5879,277.12,250.63,24.57,'PN25','condotta',''),
(871,42.014090,14.923450,0,25.09,0.0,224.9243,277.02,251.94,24.70,'PN25','condotta',''),
(872,42.013600,14.926620,0,23.80,0.0,225.1918,276.95,253.15,24.82,'PN25','condotta',''),
(873,42.012960,14.930510,0,23.67,0.0,225.5210,276.85,253.18,24.82,'PN25','condotta',''),
(874,42.012350,14.933970,0,25.23,0.0,225.8148,276.77,251.54,24.66,'PN25','condotta',''),
(875,42.011570,14.938270,0,21.02,0.0,226.1805,276.67,255.65,25.06,'PN40','condotta',''),
(876,42.010950,14.941760,0,24.79,0.0,226.4769,276.59,251.80,24.69,'PN25','condotta',''),
(877,42.010340,14.944700,0,27.77,0.0,226.7291,276.52,248.75,24.39,'PN25','condotta',''),
(878,42.009600,14.947820,0,30.88,0.0,226.9997,276.44,245.56,24.07,'PN25','condotta',''),
(879,42.008850,14.950990,0,30.01,0.0,227.2746,276.36,246.35,24.15,'PN25','condotta',''),
(880,42.007830,14.954140,0,44.71,0.0,227.5585,276.28,231.58,22.70,'PN25','condotta',''),
(881,42.006430,14.956790,0,23.15,0.0,227.8271,276.21,253.06,24.81,'PN25','condotta',''),
(882,42.005120,14.959240,0,10.28,0.0,228.0765,276.14,265.85,26.06,'PN40','condotta',''),
(883,42.004400,14.962160,0,6.52,0.0,228.3307,276.07,269.55,26.43,'PN40','condotta',''),
(884,42.003580,14.965190,0,7.53,0.0,228.5972,275.99,268.47,26.32,'PN40','condotta',''),
(885,42.002510,14.968070,0,5.23,0.0,228.8633,275.92,270.69,26.54,'PN40','condotta',''),
(886,42.001450,14.970830,0,25.47,0.0,229.1200,275.85,250.38,24.55,'PN25','condotta',''),
(887,42.000040,14.973250,0,32.89,0.0,229.3741,275.78,242.89,23.81,'PN25','condotta',''),
(888,41.998260,14.975190,0,39.86,0.0,229.6288,275.70,235.84,23.12,'PN25','condotta',''),
(889,41.996200,14.977410,0,40.95,0.0,229.9223,275.62,234.67,23.01,'PN25','condotta',''),
(890,41.994410,14.979320,0,43.00,0.0,230.1763,275.55,232.55,22.80,'PN25','condotta',''),
(891,41.992570,14.980350,0,45.85,0.0,230.3979,275.49,229.64,22.51,'PN25','condotta',''),
(892,41.994050,14.980010,0,46.32,0.0,230.5648,275.44,229.12,22.46,'PN25','condotta',''),
(893,41.995400,14.982270,0,47.16,0.0,230.8044,275.37,228.21,22.37,'PN25','condotta',''),
(894,41.996090,14.985080,0,47.31,0.0,231.0490,275.31,227.99,22.35,'PN25','condotta',''),
(895,41.997770,14.987720,0,41.15,0.0,231.3362,275.23,234.07,22.95,'PN25','condotta',''),
(896,41.998940,14.990200,0,33.96,0.0,231.5790,275.16,241.19,23.65,'PN25','condotta',''),
(897,41.997850,14.993760,0,33.25,0.0,231.8971,275.07,241.82,23.71,'PN25','condotta',''),
(898,41.998770,14.995780,0,31.88,0.0,232.0929,275.01,243.13,23.84,'PN25','condotta',''),
(899,42.000500,14.996600,0,26.17,0.0,232.2969,274.96,248.78,24.39,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(900,42.002920,14.996780,0,22.28,0.0,232.5664,274.88,252.60,24.76,'PN25','condotta',''),
(901,42.003430,14.994920,0,20.37,0.0,232.7302,274.84,254.46,24.95,'PN25','condotta',''),
(902,42.002830,14.993390,0,21.56,0.0,232.8731,274.80,253.23,24.83,'PN25','condotta',''),
(903,42.000660,14.993250,0,24.98,0.0,233.1147,274.73,249.74,24.48,'PN25','condotta',''),
(904,41.998920,14.994910,0,30.45,0.0,233.3519,274.66,244.21,23.94,'PN25','condotta',''),
(905,41.997750,14.996440,0,30.16,0.0,233.5333,274.61,244.45,23.97,'PN25','condotta',''),
(906,41.995980,14.997770,0,10.74,0.0,233.7587,274.55,263.81,25.86,'PN40','condotta',''),
(907,41.994020,14.999280,0,5.31,0.0,234.0099,274.48,269.17,26.39,'PN40','condotta',''),
(908,41.991570,15.001050,0,4.86,0.0,234.3191,274.39,269.54,26.43,'PN40','condotta',''),
(909,41.990310,15.003700,0,5.76,0.0,234.5791,274.32,268.55,26.33,'PN40','condotta',''),
(910,41.988920,15.006160,0,6.19,0.0,234.8345,274.25,268.06,26.28,'PN40','condotta',''),
(911,41.987520,15.008560,0,4.58,0.0,235.0866,274.18,269.60,26.43,'PN40','condotta',''),
(912,41.986810,15.011440,0,5.33,0.0,235.3374,274.11,268.78,26.35,'PN40','condotta',''),
(913,41.984850,15.013150,0,3.52,0.0,235.5972,274.03,270.51,26.52,'PN40','condotta',''),
(914,41.982330,15.013790,0,2.82,0.0,235.8823,273.95,271.13,26.58,'PN40','condotta',''),
(915,41.980010,15.014320,0,3.65,0.0,236.1440,273.88,270.23,26.49,'PN40','condotta',''),
(916,41.978710,15.017010,0,2.37,0.0,236.4092,273.81,271.44,26.61,'PN40','condotta',''),
(917,41.977340,15.018990,0,3.08,0.0,236.6328,273.74,270.66,26.54,'PN40','condotta',''),
(918,41.975550,15.017140,0,2.31,0.0,236.8838,273.67,271.36,26.60,'PN40','condotta',''),
(919,41.974740,15.014270,0,2.97,0.0,237.1376,273.60,270.63,26.53,'PN40','condotta',''),
(920,41.973650,15.011590,0,6.27,0.0,237.3901,273.53,267.26,26.20,'PN40','condotta',''),
(921,41.972540,15.011330,0,3.69,0.0,237.5154,273.50,269.81,26.45,'PN40','condotta',''),
(922,41.970670,15.012940,0,4.56,0.0,237.7623,273.43,268.87,26.36,'PN40','condotta',''),
(923,41.968440,15.014400,0,3.28,0.0,238.0381,273.35,270.07,26.48,'PN40','condotta',''),
(924,41.966320,15.015490,0,4.08,0.0,238.2904,273.28,269.20,26.39,'PN40','condotta',''),
(925,41.964310,15.016950,0,4.47,0.0,238.5444,273.21,268.73,26.35,'PN40','condotta',''),
(926,41.962640,15.019600,0,5.47,0.0,238.8317,273.13,267.65,26.24,'PN40','condotta',''),
(927,41.961400,15.022220,0,5.85,0.0,239.0884,273.06,267.20,26.20,'PN40','condotta',''),
(928,41.961210,15.025430,0,9.47,0.0,239.3547,272.98,263.51,25.83,'PN40','condotta',''),
(929,41.960990,15.030530,0,8.67,0.0,239.7771,272.86,264.19,25.90,'PN40','condotta',''),
(930,41.960820,15.033690,0,5.57,0.0,240.0391,272.79,267.22,26.20,'PN40','condotta',''),
(931,41.959290,15.037110,0,2.95,0.0,240.3691,272.70,269.74,26.45,'PN40','condotta',''),
(932,41.957870,15.039600,0,5.59,0.0,240.6286,272.62,267.03,26.18,'PN40','condotta',''),
(933,41.956570,15.041070,0,15.01,0.0,240.8174,272.57,257.56,25.25,'PN40','condotta',''),
(934,41.956790,15.038100,0,28.00,0.0,241.0642,272.50,244.51,23.97,'PN25','condotta',''),
(935,41.955000,15.036290,0,43.75,0.0,241.3133,272.43,228.68,22.42,'PN25','condotta',''),
(936,41.952580,15.036540,0,57.31,0.0,241.5831,272.36,215.05,21.08,'PN25','condotta',''),
(937,41.950370,15.036790,0,60.31,0.0,241.8298,272.29,211.97,20.78,'PN25','condotta',''),
(938,41.948060,15.036890,0,57.54,0.0,242.0867,272.22,214.68,21.05,'PN25','condotta',''),
(939,41.945700,15.036830,0,49.97,0.0,242.3492,272.14,222.17,21.78,'PN25','condotta',''),
(940,41.943440,15.036970,0,43.39,0.0,242.6008,272.07,228.68,22.42,'PN25','condotta',''),
(941,41.942170,15.038180,0,33.04,0.0,242.7739,272.02,238.98,23.43,'PN25','condotta',''),
(942,41.940580,15.040500,0,48.87,0.0,243.0348,271.95,223.08,21.87,'PN25','condotta',''),
(943,41.938690,15.042300,0,48.48,0.0,243.2923,271.88,223.40,21.90,'PN25','condotta',''),
(944,41.936470,15.043740,0,49.40,0.0,243.5664,271.80,222.40,21.80,'PN25','condotta',''),
(945,41.936600,15.046280,0,44.00,0.0,243.7770,271.74,227.74,22.33,'PN25','condotta',''),
(946,41.936940,15.048780,0,39.36,0.0,243.9872,271.68,232.33,22.78,'PN25','condotta',''),
(947,41.934780,15.050550,0,31.14,0.0,244.2685,271.60,240.47,23.58,'PN25','condotta',''),
(948,41.932490,15.052430,0,24.13,0.0,244.5669,271.52,247.39,24.25,'PN25','condotta',''),
(949,41.929570,15.054810,0,31.79,0.0,244.9466,271.41,239.63,23.49,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(950,41.929010,15.057770,0,31.64,0.0,245.1993,271.34,239.71,23.50,'PN25','condotta',''),
(951,41.931260,15.060480,0,27.71,0.0,245.5352,271.25,243.54,23.88,'PN25','condotta',''),
(952,41.933000,15.062570,0,24.42,0.0,245.7947,271.18,246.76,24.19,'PN25','condotta',''),
(953,41.934780,15.064700,0,21.34,0.0,246.0597,271.10,249.76,24.49,'PN25','condotta',''),
(954,41.936810,15.066300,0,17.96,0.0,246.3213,271.03,253.07,24.81,'PN25','condotta',''),
(955,41.938870,15.064510,0,19.40,0.0,246.5941,270.95,251.55,24.66,'PN25','condotta',''),
(956,41.940900,15.062950,0,8.27,0.0,246.8541,270.88,262.62,25.75,'PN40','condotta',''),
(957,41.942970,15.061040,0,4.73,0.0,247.1332,270.80,266.07,26.09,'PN40','condotta',''),
(958,41.942940,15.062930,0,4.41,0.0,247.2896,270.76,266.35,26.11,'PN40','condotta',''),
(959,41.941780,15.065600,0,3.86,0.0,247.5453,270.69,266.83,26.16,'PN40','condotta',''),
(960,41.940670,15.068780,0,3.58,0.0,247.8359,270.61,267.02,26.18,'PN40','condotta',''),
(961,41.939920,15.071680,0,2.97,0.0,248.0898,270.53,267.57,26.23,'PN40','condotta',''),
(962,41.939220,15.074760,0,3.23,0.0,248.3562,270.46,267.23,26.20,'PN40','condotta',''),
(963,41.938270,15.078920,0,4.39,0.0,248.7161,270.36,265.97,26.08,'PN40','condotta',''),
(964,41.937290,15.083260,0,4.05,0.0,249.0913,270.25,266.21,26.10,'PN40','condotta',''),
(965,41.936310,15.087560,0,4.08,0.0,249.4633,270.15,266.07,26.09,'PN40','condotta',''),
(966,41.935100,15.092910,0,4.55,0.0,249.9258,270.02,265.47,26.03,'PN40','condotta',''),
(967,41.934220,15.096820,0,4.86,0.0,250.2637,269.93,265.07,25.99,'PN40','condotta',''),
(968,41.933290,15.100920,0,5.40,0.0,250.6183,269.83,264.43,25.92,'PN40','condotta',''),
(969,41.932610,15.103890,0,4.91,0.0,250.8754,269.75,264.84,25.96,'PN40','condotta',''),
(970,41.931050,15.110750,0,5.77,0.0,251.4688,269.59,263.81,25.86,'PN40','condotta',''),
(971,41.929800,15.116310,0,5.43,0.0,251.9493,269.45,264.02,25.88,'PN40','condotta',''),
(972,41.928980,15.119920,0,5.55,0.0,252.2615,269.37,263.82,25.86,'PN40','condotta',''),
(973,41.928280,15.122850,0,5.39,0.0,252.5161,269.30,263.90,25.87,'PN40','condotta',''),
(974,41.927590,15.126010,0,5.34,0.0,252.7885,269.22,263.88,25.87,'PN40','condotta',''),
(975,41.926850,15.129240,0,6.06,0.0,253.0681,269.14,263.08,25.79,'PN40','condotta',''),
(976,41.925930,15.133220,0,5.72,0.0,253.4129,269.04,263.32,25.82,'PN40','condotta',''),
(977,41.925220,15.136410,0,2.72,0.0,253.6884,268.97,266.24,26.10,'PN40','condotta',''),
(978,41.924300,15.140440,0,3.97,0.0,254.0371,268.87,264.90,25.97,'PN40','condotta',''),
(979,41.923330,15.144680,0,3.79,0.0,254.4041,268.77,264.98,25.98,'PN40','condotta',''),
(980,41.922610,15.147830,0,3.16,0.0,254.6768,268.69,265.53,26.03,'PN40','condotta',''),
(981,41.921830,15.151240,0,2.15,0.0,254.9719,268.61,266.46,26.12,'PN40','condotta',''),
(982,41.921050,15.154700,0,3.90,0.0,255.2710,268.52,264.62,25.94,'PN40','condotta',''),
(983,41.920210,15.158240,0,4.14,0.0,255.5784,268.44,264.30,25.91,'PN40','condotta',''),
(984,41.919560,15.161500,0,2.77,0.0,255.8577,268.36,265.59,26.04,'PN40','condotta',''),
(985,41.919300,15.164500,0,3.55,0.0,256.1076,268.29,264.74,25.96,'PN40','condotta',''),
(986,41.919040,15.167810,0,3.91,0.0,256.3830,268.21,264.30,25.91,'PN40','condotta',''),
(987,41.918770,15.171170,0,4.53,0.0,256.6626,268.13,263.60,25.84,'PN40','condotta',''),
(988,41.918540,15.174530,0,4.94,0.0,256.9418,268.06,263.12,25.80,'PN40','condotta',''),
(989,41.918150,15.178730,0,4.43,0.0,257.2920,267.96,263.53,25.84,'PN40','condotta',''),
(990,41.917680,15.181750,0,4.18,0.0,257.5473,267.89,263.71,25.85,'PN40','condotta',''),
(991,41.917060,15.185700,0,4.77,0.0,257.8813,267.79,263.02,25.79,'PN40','condotta',''),
(992,41.916550,15.188980,0,5.57,0.0,258.1585,267.72,262.14,25.70,'PN40','condotta',''),
(993,41.915990,15.192630,0,6.58,0.0,258.4669,267.63,261.05,25.59,'PN40','condotta',''),
(994,41.915620,15.196020,0,6.10,0.0,258.7504,267.55,261.45,25.63,'PN40','condotta',''),
(995,41.915490,15.199210,0,6.07,0.0,259.0147,267.48,261.41,25.63,'PN40','condotta',''),
(996,41.915160,15.215700,0,5.18,0.0,260.3797,267.09,261.92,25.68,'PN40','condotta',''),
(997,41.914950,15.225870,0,5.38,0.0,261.2215,266.86,261.48,25.64,'PN40','condotta',''),
(998,41.914750,15.228990,0,5.52,0.0,261.4806,266.79,261.26,25.61,'PN40','condotta',''),
(999,41.914150,15.231920,0,5.28,0.0,261.7321,266.72,261.43,25.63,'PN40','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(1000,41.912710,15.235690,0,4.48,0.0,262.0827,266.62,262.14,25.70,'PN40','condotta',''),
(1001,41.911520,15.238390,0,4.05,0.0,262.3424,266.54,262.49,25.73,'PN40','condotta',''),
(1002,41.910280,15.241180,0,5.43,0.0,262.6113,266.47,261.04,25.59,'PN40','condotta',''),
(1003,41.908820,15.243730,0,7.11,0.0,262.8775,266.39,259.29,25.42,'PN40','condotta',''),
(1004,41.906600,15.246250,0,8.11,0.0,263.2007,266.30,258.20,25.31,'PN40','condotta',''),
(1005,41.904780,15.248370,0,8.58,0.0,263.4685,266.23,257.65,25.26,'PN40','condotta',''),
(1006,41.902970,15.250400,0,6.18,0.0,263.7307,266.16,259.98,25.49,'PN40','condotta',''),
(1007,41.900570,15.253110,0,7.81,0.0,264.0793,266.06,258.24,25.32,'PN40','condotta',''),
(1008,41.897310,15.256790,0,8.67,0.0,264.5528,265.93,257.25,25.22,'PN40','condotta',''),
(1009,41.895520,15.258810,0,10.18,0.0,264.8127,265.85,255.68,25.07,'PN40','condotta',''),
(1010,41.893890,15.260990,0,11.13,0.0,265.0685,265.78,254.65,24.97,'PN25','condotta',''),
(1011,41.891260,15.263950,0,11.73,0.0,265.4500,265.67,253.94,24.90,'PN25','condotta',''),
(1012,41.889210,15.266000,0,10.89,0.0,265.7341,265.59,254.70,24.97,'PN25','condotta',''),
(1013,41.887090,15.268340,0,8.95,0.0,266.0392,265.51,256.55,25.15,'PN40','condotta',''),
(1014,41.885310,15.270360,0,8.24,0.0,266.2984,265.44,257.20,25.22,'PN40','condotta',''),
(1015,41.883500,15.272390,0,9.23,0.0,266.5606,265.36,256.13,25.11,'PN40','condotta',''),
(1016,41.881670,15.274480,0,10.53,0.0,266.8277,265.29,254.76,24.98,'PN25','condotta',''),
(1017,41.879880,15.276510,0,13.79,0.0,267.0882,265.22,251.43,24.65,'PN25','condotta',''),
(1018,41.878100,15.278520,0,19.06,0.0,267.3467,265.14,246.09,24.13,'PN25','condotta',''),
(1019,41.876260,15.280440,0,27.17,0.0,267.6058,265.07,237.90,23.32,'PN25','condotta',''),
(1020,41.874070,15.281540,0,38.72,0.0,267.8658,265.00,226.27,22.18,'PN25','condotta',''),
(1021,41.870920,15.281530,0,46.49,0.0,268.2161,264.90,218.41,21.41,'PN25','condotta',''),
(1022,41.867490,15.281370,0,47.61,0.0,268.5977,264.79,217.18,21.29,'PN25','condotta',''),
(1023,41.864150,15.281220,0,49.70,0.0,268.9693,264.69,214.98,21.08,'PN25','condotta',''),
(1024,41.861610,15.281040,0,51.36,0.0,269.2522,264.61,213.25,20.91,'PN25','condotta',''),
(1025,41.859960,15.281650,0,52.56,0.0,269.4425,264.56,212.00,20.78,'PN25','condotta',''),
(1026,41.858800,15.287980,0,43.25,0.0,269.9823,264.40,221.15,21.68,'PN25','condotta',''),
(1027,41.858250,15.291030,0,40.16,0.0,270.2422,264.33,224.17,21.98,'PN25','condotta',''),
(1028,41.857680,15.294150,0,36.03,0.0,270.5083,264.26,228.22,22.37,'PN25','condotta',''),
(1029,41.857500,15.297620,0,33.51,0.0,270.7963,264.18,230.67,22.61,'PN25','condotta',''),
(1030,41.857200,15.300600,0,30.76,0.0,271.0454,264.11,233.35,22.88,'PN25','condotta',''),
(1031,41.854950,15.301050,0,25.94,0.0,271.2983,264.04,238.09,23.34,'PN25','condotta',''),
(1032,41.854830,15.304220,0,18.73,0.0,271.5612,263.96,245.24,24.04,'PN25','condotta',''),
(1033,41.854420,15.307190,0,18.66,0.0,271.8114,263.89,245.23,24.04,'PN25','condotta',''),
(1034,41.854090,15.310310,0,19.08,0.0,272.0724,263.82,244.74,23.99,'PN25','condotta',''),
(1035,41.853970,15.313960,0,17.91,0.0,272.3750,263.74,245.83,24.10,'PN25','condotta',''),
(1036,41.853830,15.318550,0,14.39,0.0,272.7555,263.63,249.24,24.44,'PN25','condotta',''),
(1037,41.853880,15.321550,0,15.85,0.0,273.0040,263.56,247.71,24.29,'PN25','condotta',''),
(1038,41.854320,15.324520,0,8.55,0.0,273.2548,263.49,254.94,24.99,'PN25','condotta',''),
(1039,41.856080,15.325420,0,6.56,0.0,273.4642,263.43,256.87,25.18,'PN40','condotta',''),
(1040,41.858380,15.323940,0,12.10,0.0,273.7478,263.35,251.25,24.63,'PN25','condotta',''),
(1041,41.860480,15.322430,0,11.70,0.0,274.0127,263.28,251.57,24.66,'PN25','condotta',''),
(1042,41.861620,15.325380,0,9.00,0.0,274.2879,263.20,254.20,24.92,'PN25','condotta',''),
(1043,41.862950,15.328810,0,6.20,0.0,274.6082,263.11,256.91,25.19,'PN40','condotta',''),
(1044,41.864270,15.332240,0,3.97,0.0,274.9279,263.02,259.05,25.40,'PN40','condotta',''),
(1045,41.865340,15.335110,0,2.44,0.0,275.1937,262.95,260.50,25.54,'PN40','condotta',''),
(1046,41.864380,15.336530,0,3.46,0.0,275.3525,262.90,259.44,25.44,'PN40','condotta',''),
(1047,41.865560,15.336470,0,2.93,0.0,275.4838,262.86,259.93,25.48,'PN40','condotta',''),
(1048,41.864860,15.333820,0,1.70,0.0,275.7166,262.80,261.10,25.60,'PN40','condotta',''),
(1049,41.863780,15.330950,0,5.06,0.0,275.9829,262.72,257.66,25.26,'PN40','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(1050,41.862610,15.327950,0,6.48,0.0,276.2634,262.65,256.16,25.11,'PN40','condotta',''),
(1051,41.861460,15.324950,0,9.22,0.0,276.5428,262.57,253.35,24.84,'PN25','condotta',''),
(1052,41.860360,15.322530,0,11.35,0.0,276.7776,262.50,251.16,24.62,'PN25','condotta',''),
(1053,41.857890,15.324260,0,12.11,0.0,277.0873,262.42,250.31,24.54,'PN25','condotta',''),
(1054,41.855890,15.325060,0,6.96,0.0,277.3194,262.35,255.39,25.04,'PN40','condotta',''),
(1055,41.854660,15.323250,0,9.50,0.0,277.5223,262.29,252.79,24.78,'PN25','condotta',''),
(1056,41.853840,15.326290,0,9.00,0.0,277.7901,262.22,253.22,24.83,'PN25','condotta',''),
(1057,41.853430,15.330060,0,7.78,0.0,278.1056,262.13,254.35,24.94,'PN25','condotta',''),
(1058,41.853240,15.336050,0,7.40,0.0,278.6022,261.99,254.59,24.96,'PN25','condotta',''),
(1059,41.853120,15.339550,0,8.94,0.0,278.8924,261.91,252.97,24.80,'PN25','condotta',''),
(1060,41.852990,15.343630,0,8.52,0.0,279.2306,261.82,253.30,24.83,'PN25','condotta',''),
(1061,41.852890,15.346720,0,8.63,0.0,279.4868,261.74,253.12,24.82,'PN25','condotta',''),
(1062,41.852760,15.350430,0,9.05,0.0,279.7944,261.66,252.61,24.77,'PN25','condotta',''),
(1063,41.852580,15.353700,0,8.30,0.0,280.0660,261.58,253.28,24.83,'PN25','condotta',''),
(1064,41.852390,15.357350,0,7.50,0.0,280.3691,261.50,254.00,24.90,'PN25','condotta',''),
(1065,41.852220,15.360520,0,6.13,0.0,280.6323,261.42,255.29,25.03,'PN40','condotta',''),
(1066,41.852040,15.363930,0,6.49,0.0,280.9154,261.34,254.85,24.99,'PN25','condotta',''),
(1067,41.851870,15.367220,0,6.79,0.0,281.1886,261.27,254.48,24.95,'PN25','condotta',''),
(1068,41.851700,15.370320,0,5.31,0.0,281.4460,261.20,255.88,25.09,'PN40','condotta',''),
(1069,41.851530,15.373630,0,5.99,0.0,281.7208,261.12,255.13,25.01,'PN40','condotta',''),
(1070,41.851460,15.377550,0,9.88,0.0,282.0456,261.03,251.15,24.62,'PN25','condotta',''),
(1071,41.851460,15.381210,0,11.17,0.0,282.3488,260.94,249.77,24.49,'PN25','condotta',''),
(1072,41.851460,15.384550,0,11.21,0.0,282.6254,260.86,249.66,24.48,'PN25','condotta',''),
(1073,41.851450,15.388080,0,13.06,0.0,282.9178,260.78,247.72,24.29,'PN25','condotta',''),
(1074,41.851460,15.391120,0,12.61,0.0,283.1696,260.71,248.11,24.32,'PN25','condotta',''),
(1075,41.851690,15.394340,0,13.53,0.0,283.4375,260.64,247.11,24.23,'PN25','condotta',''),
(1076,41.851850,15.398710,0,14.26,0.0,283.7999,260.54,246.28,24.14,'PN25','condotta',''),
(1077,41.851910,15.401880,0,15.03,0.0,284.0625,260.46,245.43,24.06,'PN25','condotta',''),
(1078,41.852000,15.406860,0,15.43,0.0,284.4751,260.35,244.92,24.01,'PN25','condotta',''),
(1079,41.852140,15.415260,0,13.80,0.0,285.1710,260.15,246.35,24.15,'PN25','condotta',''),
(1080,41.852260,15.421770,0,12.87,0.0,285.7104,260.00,247.13,24.23,'PN25','condotta',''),
(1081,41.852350,15.427500,0,11.77,0.0,286.1851,259.87,248.10,24.32,'PN25','condotta',''),
(1082,41.852410,15.430950,0,10.64,0.0,286.4709,259.79,249.15,24.43,'PN25','condotta',''),
(1083,41.852460,15.434000,0,9.44,0.0,286.7236,259.72,250.28,24.54,'PN25','condotta',''),
(1084,41.852530,15.438060,0,9.26,0.0,287.0600,259.62,250.36,24.55,'PN25','condotta',''),
(1085,41.852590,15.441570,0,8.30,0.0,287.3508,259.54,251.24,24.63,'PN25','condotta',''),
(1086,41.852650,15.444950,0,8.65,0.0,287.6308,259.46,250.81,24.59,'PN25','condotta',''),
(1087,41.852770,15.448020,0,8.95,0.0,287.8854,259.39,250.44,24.55,'PN25','condotta',''),
(1088,41.853390,15.451230,0,9.23,0.0,288.1601,259.32,250.08,24.52,'PN25','condotta',''),
(1089,41.854200,15.454050,0,9.40,0.0,288.4104,259.25,249.85,24.49,'PN25','condotta',''),
(1090,41.852740,15.456300,0,12.62,0.0,288.6575,259.18,246.56,24.17,'PN25','condotta',''),
(1091,41.850710,15.455770,0,12.24,0.0,288.8875,259.11,246.87,24.20,'PN25','condotta',''),
(1092,41.849000,15.453170,0,13.76,0.0,289.1748,259.03,245.27,24.05,'PN25','condotta',''),
(1093,41.847280,15.450960,0,17.28,0.0,289.4395,258.96,241.67,23.69,'PN25','condotta',''),
(1094,41.845360,15.449180,0,25.91,0.0,289.6990,258.88,232.98,22.84,'PN25','condotta',''),
(1095,41.843120,15.447150,0,27.03,0.0,289.9995,258.80,231.77,22.72,'PN25','condotta',''),
(1096,41.841080,15.445340,0,25.54,0.0,290.2714,258.72,233.18,22.86,'PN25','condotta',''),
(1097,41.838870,15.443890,0,30.07,0.0,290.5449,258.65,228.58,22.41,'PN25','condotta',''),
(1098,41.836760,15.442520,0,36.83,0.0,290.8056,258.57,221.74,21.74,'PN25','condotta',''),
(1099,41.834490,15.441050,0,45.55,0.0,291.0858,258.50,212.95,20.88,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(1100,41.832390,15.439690,0,44.44,0.0,291.3451,258.42,213.98,20.98,'PN25','condotta',''),
(1101,41.830390,15.438310,0,42.87,0.0,291.5952,258.35,215.48,21.13,'PN25','condotta',''),
(1102,41.828040,15.437090,0,50.02,0.0,291.8753,258.27,208.26,20.42,'PN25','condotta',''),
(1103,41.825700,15.437000,0,62.32,0.0,292.1357,258.20,195.88,19.20,'PN25','condotta',''),
(1104,41.823340,15.436920,0,72.45,0.0,292.3982,258.13,185.68,18.20,'PN25','condotta',''),
(1105,41.820280,15.437690,0,81.65,0.0,292.7443,258.03,176.38,17.29,'PN25','condotta',''),
(1106,41.817460,15.438550,0,92.42,0.0,293.0659,257.94,165.52,16.23,'PN25','condotta',''),
(1107,41.814820,15.439480,0,106.12,0.0,293.3694,257.86,151.73,14.88,'PN16','condotta',''),
(1108,41.812550,15.440000,0,119.01,0.0,293.6255,257.78,138.77,13.61,'PN16','condotta',''),
(1109,41.810280,15.440340,0,124.15,0.0,293.8795,257.71,133.56,13.09,'PN16','condotta',''),
(1110,41.807510,15.441440,0,124.59,0.0,294.2007,257.62,133.03,13.04,'PN16','condotta',''),
(1111,41.805420,15.442880,0,117.15,0.0,294.4619,257.55,140.40,13.76,'PN16','condotta',''),
(1112,41.803340,15.444300,0,112.59,0.0,294.7214,257.48,144.89,14.20,'PN16','condotta',''),
(1113,41.800720,15.445880,0,99.38,0.0,295.0409,257.39,158.01,15.49,'PN16','condotta',''),
(1114,41.798110,15.447230,0,87.75,0.0,295.3519,257.30,169.55,16.62,'PN25','condotta',''),
(1115,41.795370,15.447800,0,82.15,0.0,295.6602,257.22,175.07,17.16,'PN25','condotta',''),
(1116,41.792630,15.447860,0,73.11,0.0,295.9649,257.13,184.02,18.04,'PN25','condotta',''),
(1117,41.790030,15.447890,0,67.98,0.0,296.2541,257.05,189.07,18.54,'PN25','condotta',''),
(1118,41.788000,15.450420,0,64.76,0.0,296.5622,256.96,192.20,18.84,'PN25','condotta',''),
(1119,41.786160,15.453000,0,64.49,0.0,296.8582,256.88,192.39,18.86,'PN25','condotta',''),
(1120,41.784460,15.454760,0,65.83,0.0,297.0970,256.81,190.98,18.72,'PN25','condotta',''),
(1121,41.782870,15.452710,0,68.71,0.0,297.3423,256.74,188.03,18.43,'PN25','condotta',''),
(1122,41.781000,15.450960,0,70.84,0.0,297.5958,256.67,185.83,18.22,'PN25','condotta',''),
(1123,41.779930,15.448450,0,72.39,0.0,297.8355,256.61,184.21,18.06,'PN25','condotta',''),
(1124,41.779650,15.445370,0,70.12,0.0,298.0928,256.53,186.41,18.28,'PN25','condotta',''),
(1125,41.779340,15.441960,0,59.09,0.0,298.3777,256.45,197.37,19.35,'PN25','condotta',''),
(1126,41.779000,15.438980,0,54.73,0.0,298.6277,256.38,201.65,19.77,'PN25','condotta',''),
(1127,41.777810,15.436880,0,54.93,0.0,298.8464,256.32,201.40,19.74,'PN25','condotta',''),
(1128,41.775450,15.435410,0,54.96,0.0,299.1357,256.24,201.29,19.73,'PN25','condotta',''),
(1129,41.772970,15.433770,0,52.77,0.0,299.4432,256.16,203.38,19.94,'PN25','condotta',''),
(1130,41.769920,15.431900,0,49.49,0.0,299.8161,256.05,206.56,20.25,'PN25','condotta',''),
(1131,41.767570,15.430420,0,50.00,0.0,300.1048,255.97,205.97,20.19,'PN25','condotta',''),
(1132,41.764100,15.428220,0,48.82,0.0,300.5316,255.85,207.03,20.30,'PN25','condotta',''),
(1133,41.761980,15.426840,0,47.55,0.0,300.7937,255.78,208.23,20.41,'PN25','condotta',''),
(1134,41.759920,15.425520,0,46.55,0.0,301.0475,255.71,209.15,20.51,'PN25','condotta',''),
(1135,41.757010,15.423680,0,46.87,0.0,301.4053,255.61,208.74,20.46,'PN25','condotta',''),
(1136,41.752650,15.420920,0,44.31,0.0,301.9415,255.46,211.15,20.70,'PN25','condotta',''),
(1137,41.750550,15.419590,0,43.05,0.0,302.1997,255.38,212.34,20.82,'PN25','condotta',''),
(1138,41.747280,15.417480,0,43.44,0.0,302.6033,255.27,211.83,20.77,'PN25','condotta',''),
(1139,41.744940,15.416010,0,44.18,0.0,302.8906,255.19,211.01,20.69,'PN25','condotta',''),
(1140,41.742860,15.414540,0,46.37,0.0,303.1521,255.12,208.75,20.47,'PN25','condotta',''),
(1141,41.740490,15.411140,0,46.57,0.0,303.5381,255.01,208.44,20.44,'PN25','condotta',''),
(1142,41.738050,15.407690,0,46.11,0.0,303.9325,254.90,208.79,20.47,'PN25','condotta',''),
(1143,41.736360,15.405210,0,47.35,0.0,304.2112,254.82,207.47,20.34,'PN25','condotta',''),
(1144,41.734210,15.402800,0,46.82,0.0,304.5229,254.73,207.91,20.38,'PN25','condotta',''),
(1145,41.732080,15.400810,0,48.10,0.0,304.8116,254.65,206.55,20.25,'PN25','condotta',''),
(1146,41.730130,15.399040,0,48.36,0.0,305.0735,254.58,206.22,20.22,'PN25','condotta',''),
(1147,41.727990,15.397380,0,47.56,0.0,305.3485,254.50,206.94,20.29,'PN25','condotta',''),
(1148,41.725930,15.395750,0,46.27,0.0,305.6145,254.43,208.15,20.41,'PN25','condotta',''),
(1149,41.723730,15.394660,0,47.68,0.0,305.8753,254.35,206.67,20.26,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(1150,41.721080,15.393200,0,49.29,0.0,306.1939,254.27,204.98,20.10,'PN25','condotta',''),
(1151,41.718970,15.392100,0,48.84,0.0,306.4457,254.20,205.35,20.13,'PN25','condotta',''),
(1152,41.716800,15.390960,0,50.56,0.0,306.7049,254.12,203.56,19.96,'PN25','condotta',''),
(1153,41.715430,15.388880,0,53.44,0.0,306.9351,254.06,200.62,19.67,'PN25','condotta',''),
(1154,41.715410,15.385840,0,53.68,0.0,307.1874,253.99,200.31,19.64,'PN25','condotta',''),
(1155,41.714800,15.380890,0,58.26,0.0,307.6039,253.87,195.62,19.18,'PN25','condotta',''),
(1156,41.714360,15.377510,0,60.91,0.0,307.8886,253.79,192.89,18.91,'PN25','condotta',''),
(1157,41.713910,15.374200,0,59.94,0.0,308.1679,253.71,193.77,19.00,'PN25','condotta',''),
(1158,41.713320,15.369760,0,59.42,0.0,308.5422,253.61,194.19,19.04,'PN25','condotta',''),
(1159,41.712870,15.366580,0,60.09,0.0,308.8109,253.53,193.44,18.96,'PN25','condotta',''),
(1160,41.712110,15.362970,0,60.94,0.0,309.1222,253.45,192.50,18.87,'PN25','condotta',''),
(1161,41.711510,15.359720,0,61.46,0.0,309.4001,253.37,191.90,18.81,'PN25','condotta',''),
(1162,41.711300,15.356390,0,61.55,0.0,309.6775,253.29,191.74,18.80,'PN25','condotta',''),
(1163,41.711360,15.353370,0,62.44,0.0,309.9283,253.22,190.78,18.70,'PN25','condotta',''),
(1164,41.711840,15.349580,0,61.99,0.0,310.2474,253.13,191.14,18.74,'PN25','condotta',''),
(1165,41.712280,15.346010,0,63.66,0.0,310.5478,253.05,189.39,18.57,'PN25','condotta',''),
(1166,41.712830,15.343050,0,65.22,0.0,310.8010,252.98,187.75,18.41,'PN25','condotta',''),
(1167,41.714080,15.340150,0,66.01,0.0,311.0789,252.90,186.89,18.32,'PN25','condotta',''),
(1168,41.715320,15.337530,0,67.55,0.0,311.3364,252.83,185.28,18.16,'PN25','condotta',''),
(1169,41.715360,15.335610,0,67.78,0.0,311.4958,252.78,185.00,18.14,'PN25','condotta',''),
(1170,41.713120,15.336090,0,69.91,0.0,311.7481,252.71,182.80,17.92,'PN25','condotta',''),
(1171,41.710990,15.336660,0,70.49,0.0,311.9896,252.64,182.15,17.86,'PN25','condotta',''),
(1172,41.708780,15.337260,0,71.87,0.0,312.2403,252.57,180.71,17.72,'PN25','condotta',''),
(1173,41.706380,15.338420,0,71.63,0.0,312.5241,252.49,180.87,17.73,'PN25','condotta',''),
(1174,41.704250,15.339720,0,72.73,0.0,312.7843,252.42,179.69,17.62,'PN25','condotta',''),
(1175,41.701360,15.341440,0,76.32,0.0,313.1360,252.32,176.00,17.26,'PN25','condotta',''),
(1176,41.699140,15.342700,0,79.32,0.0,313.4041,252.25,172.93,16.95,'PN25','condotta',''),
(1177,41.696740,15.343290,0,81.47,0.0,313.6754,252.17,170.70,16.74,'PN25','condotta',''),
(1178,41.694330,15.343830,0,84.10,0.0,313.9471,252.09,167.99,16.47,'PN25','condotta',''),
(1179,41.692070,15.344260,0,86.34,0.0,314.2009,252.02,165.68,16.24,'PN25','condotta',''),
(1180,41.689570,15.344730,0,91.05,0.0,314.4816,251.95,160.89,15.77,'PN16','condotta',''),
(1181,41.686570,15.345270,0,93.82,0.0,314.8182,251.85,158.03,15.49,'PN16','condotta',''),
(1182,41.684090,15.345750,0,100.33,0.0,315.0969,251.77,151.44,14.85,'PN16','condotta',''),
(1183,41.681700,15.346180,0,102.04,0.0,315.3650,251.70,149.66,14.67,'PN16','condotta',''),
(1184,41.678890,15.346590,0,94.02,0.0,315.6793,251.61,157.59,15.45,'PN16','condotta',''),
(1185,41.676630,15.346910,0,90.29,0.0,315.9320,251.54,161.25,15.81,'PN16','condotta',''),
(1186,41.674060,15.347840,0,88.90,0.0,316.2280,251.46,162.56,15.94,'PN16','condotta',''),
(1187,41.671980,15.349570,0,87.15,0.0,316.5003,251.38,164.23,16.10,'PN25','condotta',''),
(1188,41.670330,15.351840,0,84.91,0.0,316.7634,251.31,166.40,16.31,'PN25','condotta',''),
(1189,41.668050,15.351020,0,88.58,0.0,317.0259,251.23,162.65,15.95,'PN16','condotta',''),
(1190,41.665810,15.349240,0,96.71,0.0,317.3156,251.15,154.44,15.14,'PN16','condotta',''),
(1191,41.663350,15.345840,0,99.23,0.0,317.7088,251.04,151.82,14.88,'PN16','condotta',''),
(1192,41.661740,15.343250,0,95.60,0.0,317.9887,250.96,155.36,15.23,'PN16','condotta',''),
(1193,41.659840,15.340250,0,85.06,0.0,318.3154,250.87,165.82,16.26,'PN25','condotta',''),
(1194,41.658220,15.337670,0,78.92,0.0,318.5953,250.79,171.88,16.85,'PN25','condotta',''),
(1195,41.656710,15.335270,0,78.80,0.0,318.8560,250.72,171.92,16.85,'PN25','condotta',''),
(1196,41.654910,15.332400,0,78.17,0.0,319.1673,250.63,172.46,16.91,'PN25','condotta',''),
(1197,41.653180,15.329630,0,78.11,0.0,319.4673,250.55,172.44,16.91,'PN25','condotta',''),
(1198,41.651330,15.326680,0,81.34,0.0,319.7873,250.46,169.12,16.58,'PN25','condotta',''),
(1199,41.649480,15.323720,0,82.81,0.0,320.1079,250.37,167.56,16.43,'PN25','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(1200,41.647570,15.320670,0,83.07,0.0,320.4385,250.28,167.21,16.39,'PN25','condotta',''),
(1201,41.645920,15.318050,0,82.26,0.0,320.7232,250.20,167.93,16.46,'PN25','condotta',''),
(1202,41.643910,15.314830,0,79.76,0.0,321.0719,250.10,170.34,16.70,'PN25','condotta',''),
(1203,41.642400,15.312440,0,80.09,0.0,321.3319,250.03,169.94,16.66,'PN25','condotta',''),
(1204,41.640720,15.309780,0,79.52,0.0,321.6213,249.95,170.43,16.71,'PN25','condotta',''),
(1205,41.639220,15.307390,0,80.16,0.0,321.8807,249.87,169.71,16.64,'PN25','condotta',''),
(1206,41.637070,15.303950,0,81.09,0.0,322.2533,249.77,168.68,16.54,'PN25','condotta',''),
(1207,41.635430,15.301380,0,80.81,0.0,322.5342,249.69,168.88,16.56,'PN25','condotta',''),
(1208,41.633860,15.298890,0,82.33,0.0,322.8049,249.61,167.29,16.40,'PN25','condotta',''),
(1209,41.632580,15.295960,0,85.97,0.0,323.0870,249.54,163.57,16.04,'PN25','condotta',''),
(1210,41.630890,15.291960,0,91.92,0.0,323.4689,249.43,157.51,15.44,'PN16','condotta',''),
(1211,41.629770,15.289270,0,95.21,0.0,323.7248,249.36,154.14,15.11,'PN16','condotta',''),
(1212,41.628440,15.286030,0,98.58,0.0,324.0320,249.27,150.69,14.77,'PN16','condotta',''),
(1213,41.627300,15.283270,0,100.36,0.0,324.2941,249.20,148.83,14.59,'PN16','condotta',''),
(1214,41.626190,15.280630,0,99.61,0.0,324.5458,249.13,149.52,14.66,'PN16','condotta',''),
(1215,41.625000,15.277840,0,99.15,0.0,324.8128,249.05,149.91,14.70,'PN16','condotta',''),
(1216,41.623830,15.275030,0,100.65,0.0,325.0802,248.98,148.33,14.54,'PN16','condotta',''),
(1217,41.622640,15.272200,0,103.06,0.0,325.3501,248.90,145.84,14.30,'PN16','condotta',''),
(1218,41.620910,15.268040,0,108.66,0.0,325.7458,248.79,140.14,13.74,'PN16','condotta',''),
(1219,41.619800,15.265370,0,111.76,0.0,325.9998,248.72,136.96,13.43,'PN16','condotta',''),
(1220,41.618660,15.262640,0,113.18,0.0,326.2597,248.65,135.47,13.28,'PN16','condotta',''),
(1221,41.617520,15.259910,0,115.19,0.0,326.5196,248.57,133.39,13.08,'PN16','condotta',''),
(1222,41.616310,15.256960,0,113.45,0.0,326.7993,248.50,135.05,13.24,'PN16','condotta',''),
(1223,41.615150,15.254250,0,112.95,0.0,327.0589,248.42,135.47,13.28,'PN16','condotta',''),
(1224,41.613950,15.251480,0,114.32,0.0,327.3251,248.35,134.03,13.14,'PN16','condotta',''),
(1225,41.612820,15.248690,0,119.35,0.0,327.5889,248.28,128.92,12.64,'PN16','condotta',''),
(1226,41.612200,15.245220,0,127.97,0.0,327.8855,248.19,120.23,11.79,'PN16','condotta',''),
(1227,41.611760,15.242030,0,132.47,0.0,328.1552,248.12,115.64,11.34,'PN16','condotta',''),
(1228,41.611300,15.238800,0,127.77,0.0,328.4285,248.04,120.27,11.79,'PN16','condotta',''),
(1229,41.610790,15.234940,0,127.22,0.0,328.7544,247.95,120.73,11.84,'PN16','condotta',''),
(1230,41.610370,15.231760,0,128.11,0.0,329.0229,247.87,119.77,11.74,'PN16','condotta',''),
(1231,41.609620,15.226380,0,128.24,0.0,329.4779,247.75,119.51,11.72,'PN16','condotta',''),
(1232,41.609200,15.223410,0,128.91,0.0,329.7292,247.68,118.77,11.64,'PN16','condotta',''),
(1233,41.608760,15.220270,0,130.47,0.0,329.9948,247.60,117.13,11.48,'PN16','condotta',''),
(1234,41.608140,15.215850,0,132.29,0.0,330.3687,247.50,115.20,11.29,'PN16','condotta',''),
(1235,41.607640,15.212250,0,134.47,0.0,330.6731,247.41,112.95,11.07,'PN16','condotta',''),
(1236,41.607200,15.209150,0,136.76,0.0,330.9354,247.34,110.58,10.84,'PN16','condotta',''),
(1237,41.607970,15.206770,0,138.90,0.0,331.1510,247.28,108.37,10.62,'PN16','condotta',''),
(1238,41.610010,15.204600,0,141.71,0.0,331.4409,247.20,105.49,10.34,'PN16','condotta',''),
(1239,41.611860,15.202240,0,145.18,0.0,331.7252,247.12,101.93,9.99,'PN16','condotta',''),
(1240,41.613370,15.200000,0,150.00,0.0,331.9759,247.05,97.05,9.51,'PN16','condotta',''),
(1241,41.614440,15.197220,0,142.84,0.0,332.2358,246.97,104.14,10.21,'PN16','condotta',''),
(1242,41.615390,15.194490,0,138.86,0.0,332.4862,246.90,108.05,10.59,'PN16','condotta',''),
(1243,41.616270,15.191490,0,140.42,0.0,332.7541,246.83,106.41,10.43,'PN16','condotta',''),
(1244,41.618030,15.189110,0,135.79,0.0,333.0324,246.75,110.96,10.88,'PN16','condotta',''),
(1245,41.620470,15.187500,0,136.19,0.0,333.3349,246.67,110.47,10.83,'PN16','condotta',''),
(1246,41.622570,15.186010,0,135.04,0.0,333.5992,246.59,111.56,10.94,'PN16','condotta',''),
(1247,41.624560,15.184370,0,136.22,0.0,333.8591,246.52,110.30,10.81,'PN16','condotta',''),
(1248,41.626550,15.182950,0,139.12,0.0,334.1099,246.45,107.33,10.52,'PN16','condotta',''),
(1249,41.628800,15.181940,0,155.60,0.0,334.3738,246.38,90.77,8.90,'PN16','condotta','');

INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note) VALUES
(1250,41.630540,15.179790,0,162.61,0.0,334.6372,246.30,83.69,8.21,'PN16','condotta',''),
(1251,41.633400,15.175780,0,164.55,0.0,335.0978,246.17,81.62,8.00,'PN16','condotta',''),
(1252,41.635810,15.171610,0,165.12,0.0,335.5359,246.05,80.93,7.93,'PN16','condotta',''),
(1253,41.637260,15.169120,0,166.65,0.0,335.7982,245.98,79.32,7.78,'PN16','condotta',''),
(1254,41.640330,15.163990,0,164.42,0.0,336.3444,245.82,81.41,7.98,'PN16','condotta',''),
(1255,41.641420,15.160970,0,166.12,0.0,336.6231,245.75,79.62,7.81,'PN16','condotta',''),
(1256,41.642000,15.157600,0,167.52,0.0,336.9104,245.67,78.15,7.66,'PN16','condotta',''),
(1257,41.642560,15.154520,0,177.33,0.0,337.1738,245.59,68.26,6.69,'PN16','condotta',''),
(1258,41.643080,15.151530,0,185.27,0.0,337.4289,245.52,60.25,5.91,'PN16','condotta',''),
(1259,41.644110,15.148890,0,187.92,0.0,337.6764,245.45,57.53,5.64,'PN16','condotta',''),
(1260,41.646200,15.149900,0,184.13,0.0,337.9235,245.38,61.26,6.01,'PN16','condotta',''),
(1261,41.647370,15.152600,0,178.13,0.0,338.1828,245.31,67.17,6.59,'PN16','condotta',''),
(1262,41.648550,15.155300,0,170.30,0.0,338.4427,245.24,74.93,7.35,'PN16','condotta',''),
(1263,41.650080,15.158840,0,160.57,0.0,338.7825,245.14,84.57,8.29,'PN16','condotta',''),
(1264,41.651250,15.161500,0,152.45,0.0,339.0390,245.07,92.62,9.08,'PN16','condotta',''),
(1265,41.652450,15.164140,0,146.02,0.0,339.2957,245.00,98.98,9.70,'PN16','arrivo','Finocchito - Arrivo + Turbina');

-- ZONE GALLERIA (dove DEM > piezometrica)
INSERT INTO ot_trincee (start_km,end_km,length_km,max_depth,tipo) VALUES
(0.5, 3.5, 3.0, 42, 'galleria'),
(5.0, 14.0, 9.0, 42, 'galleria'),
(149.5, 150.5, 1.0, 11, 'trincea');

INSERT INTO ot_settings (`key`,`value`) VALUES 
('perdita_km','0.28'),('quota_partenza','340'),('portata_mc_s','4.8'),
('diametro_dn2500','2500'),('diametro_dn2200','2200'),
('versione','10.1'),('data_generazione','2026-02-13');
