<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>GAA OptiTrace v11</title>
<style>
:root{--bg:#0a0f1e;--panel:#111827;--card:#1e293b;--border:#1e3a5f;--txt:#c8d6e5;--accent:#0ea5e9;--green:#22c55e;--yellow:#eab308;--red:#ef4444;--purple:#a855f7;--orange:#f97316}
*{margin:0;padding:0;box-sizing:border-box}
body{font:13px/1.5 'Segoe UI',system-ui,sans-serif;background:var(--bg);color:var(--txt)}

/* TOPBAR */
.top{background:var(--panel);padding:6px 12px;display:flex;align-items:center;gap:8px;border-bottom:2px solid var(--accent);flex-wrap:wrap;z-index:100}
.top h1{color:var(--accent);font-size:15px;cursor:pointer}
.top h1:hover{text-decoration:underline}
.pill{background:#0c2d57;padding:2px 8px;border-radius:10px;font-size:11px;white-space:nowrap}
.pill b{color:var(--accent)}
.pill.ok b{color:var(--green)}
.pill.warn b{color:var(--yellow)}
.pill.err b{color:var(--red)}

/* LAYOUT */
.wrap{display:flex;height:calc(100vh - 38px)}
#map{flex:1;min-width:50%}
.side{width:50%;display:flex;flex-direction:column;background:var(--bg)}

/* TABS */
.tabs{display:flex;background:var(--panel)}
.tab{padding:6px 12px;cursor:pointer;color:#64748b;font-size:12px;border-bottom:2px solid transparent;transition:.2s}
.tab:hover{color:#94a3b8}
.tab.on{color:var(--accent);border-color:var(--accent)}
.tp{display:none;padding:8px;overflow-y:auto;flex:1}
.tp.on{display:block}

/* CARDS */
.cd{background:var(--card);padding:8px 10px;border-radius:6px;margin:6px 0;font-size:12px;line-height:1.6;border-left:3px solid var(--accent)}
.cd h3{color:var(--accent);font-size:13px;margin-bottom:4px}
.cd.ok{border-color:var(--green)}
.cd.warn{border-color:var(--yellow)}
.cd.err{border-color:var(--red)}

/* TABLE */
table{width:100%;border-collapse:collapse;font-size:10px}
th{background:var(--panel);color:var(--accent);padding:4px 5px;text-align:left;position:sticky;top:0;z-index:2;font-size:10px}
td{padding:3px 5px;border-bottom:1px solid #0f1729;cursor:pointer}
tr:hover{background:var(--border)}
tr.v td{background:#1a0505;color:#fca5a5}
tr.s td{background:#1a1305;color:#fcd34d}
tr.t td{background:#0f051a;color:#d8b4fe}
tr.ok td{color:#86efac}

/* CHART */
canvas{width:100%;border-radius:4px;cursor:crosshair}

/* LEGEND */
.leg{display:flex;gap:6px;padding:4px 0;flex-wrap:wrap;font-size:10px}
.li{display:flex;align-items:center;gap:3px}
.lc{width:8px;height:8px;border-radius:50%}

/* MODAL */
.modal-bg{display:none;position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,.7);z-index:1000;justify-content:center;align-items:center}
.modal-bg.show{display:flex}
.modal{background:var(--panel);border:1px solid var(--accent);border-radius:12px;max-width:700px;width:95%;max-height:85vh;overflow-y:auto;padding:20px;position:relative}
.modal h2{color:var(--accent);margin-bottom:12px}
.modal h3{color:var(--yellow);margin:12px 0 4px}
.modal p{margin:4px 0;font-size:12px;line-height:1.6}
.modal .close{position:absolute;top:10px;right:14px;color:#94a3b8;font-size:20px;cursor:pointer}
.modal .close:hover{color:#fff}
.modal .schema{background:var(--bg);padding:10px;border-radius:6px;font-family:monospace;font-size:11px;margin:8px 0;white-space:pre;overflow-x:auto;line-height:1.4}
.modal ul{margin:4px 0 4px 16px;font-size:12px}
.modal li{margin:2px 0}

/* BTNS */
.btn{background:var(--accent);color:#fff;border:none;padding:5px 12px;border-radius:4px;cursor:pointer;font-size:11px;margin:2px;transition:.2s}
.btn:hover{filter:brightness(1.2)}
.btn.g{background:var(--green)}.btn.w{background:var(--yellow);color:#000}.btn.r{background:var(--red)}.btn.p{background:var(--purple)}

/* RESPONSIVE */
@media(max-width:900px){.wrap{flex-direction:column}#map{min-height:40vh}.side{width:100%}}
</style>
</head>
<body>

<!-- MODAL SPIEGAZIONE -->
<div class="modal-bg" id="helpModal">
<div class="modal">
<span class="close" onclick="closeHelp()">&times;</span>
<h2>📘 Come funziona GAA OptiTrace</h2>

<h3>🎯 Cos'è questo strumento</h3>
<p>OptiTrace visualizza il tracciato del <b>Grande Acquedotto Adriatico (GAA)</b> — un acquedotto lungo ~216km che trasporta acqua dalle sorgenti del Tirino (340m slm) a Finocchito (146m slm) interamente <b>per gravità</b>, senza pompe.</p>

<h3>📊 Le 3 linee del profilo</h3>
<div class="schema">
QUOTA (m)
  340 ─ ● Partenza (Capestrano, 340m)
   |     ╲  <span style="color:#ef4444">━━ PIEZOMETRICA (rossa)</span> = energia disponibile
   |      ╲    Scende di 0.28 m/km (perdite per attrito)
   |       ╲   
   |   <span style="color:#8B7355">▓▓▓ TERRENO DEM Google (marrone)</span> = profilo reale del suolo
   |   ▓▓▓▓▓▓  Dove DEM > KML → serve trincea o galleria
   |      ╲ ▓
   |  <span style="color:#3b82f6">- - KML INGEGNERE (blu tratteggiato)</span> = livelletta del tubo
   |       ╲    Progettata per scendere sempre
  146 ─────── ● Arrivo (Finocchito, 146m)
         0   50  100  150  km</div>

<h3>✅ Quando il sistema funziona</h3>
<ul>
<li>La <b>piezometrica</b> (rossa) deve essere SEMPRE sopra la <b>livelletta KML</b> (blu)</li>
<li>Se piez &gt; KML → <span style="color:#22c55e">OK</span>, l'acqua scorre per gravità</li>
<li>La differenza piez − KML = <b>margine</b> → pressione nel tubo</li>
<li>Il margine diviso 10.2 = <b>pressione in bar</b></li>
</ul>

<h3>❌ Violazione piezometrica</h3>
<p>Se la piezometrica scende SOTTO la livelletta del tubo → l'acqua non può scorrere lì. Soluzioni:</p>
<ul>
<li><b>Torrino piezometrico</b> — disconnette la pressione. La piez riparte dalla quota del torrino</li>
<li><b>Accorciare il percorso</b> — meno km = meno perdite = piez più alta</li>
<li><b>Abbassare il tubo</b> — portare la livelletta più in basso (più trincea)</li>
</ul>

<h3>🏗️ Trincea vs Galleria</h3>
<p>Dove il <b>terreno (DEM Google)</b> è sopra la <b>livelletta KML</b>, serve scavare:</p>
<ul>
<li><b>Trincea</b>: scavo a cielo aperto (profondità &lt;10m)</li>
<li><b>Galleria</b>: scavo in sotterraneo (profondità &gt;10m)</li>
<li>NON è una violazione piezometrica! È un'opera civile</li>
</ul>

<h3>⚡ Torrino piezometrico</h3>
<p>Un torrino è una vasca aperta all'atmosfera che "resetta" la pressione. Dopo il torrino, la piezometrica riparte dalla quota del torrino (+6m pelo libero). Serve quando:</p>
<ul>
<li>La pressione diventa troppo alta (&gt;25 bar)</li>
<li>Si vuole sezionare il sistema per manutenzione</li>
<li>Si vuole generare energia con una turbina prima del torrino</li>
</ul>

<h3>📋 Colori nella mappa e tabella</h3>
<ul>
<li><span style="color:#22c55e">● Verde</span> = OK, margine positivo</li>
<li><span style="color:#eab308">● Giallo</span> = Terreno in salita (&gt;20m)</li>
<li><span style="color:#ef4444">● Rosso</span> = Violazione piezometrica (piez &lt; livelletta)</li>
<li><span style="color:#a855f7">● Viola</span> = Torrino piezometrico</li>
<li><span style="color:#f97316">▬ Arancione</span> = Tratta DN2500</li>
<li><span style="color:#06b6d4">▬ Ciano</span> = Tratta DN2200</li>
</ul>

<h3>🔧 Come usare</h3>
<ul>
<li><b>Mappa</b>: clicca un marker per vedere i dettagli. Usa Satellite per verificare edifici</li>
<li><b>Profilo</b>: trascina per zoomare, clicca sul grafico zoomato per centrare la mappa</li>
<li><b>Tabella</b>: clicca una riga per andare al punto sulla mappa</li>
<li><b>Salva</b>: salva le modifiche nel database MySQL</li>
<li><b>Snapshot</b>: salva una versione per tornare indietro</li>
<li><b>Esporta KML</b>: scarica per aprire in Google Earth</li>
</ul>

<h3>📐 Parametri chiave</h3>
<ul>
<li>Portata: 4.8 m³/s (151 Mm³/anno)</li>
<li>Perdite distribuite: 0.28 m/km (DN2200-2500, PRFV)</li>
<li>Pressione max ammessa: PN16 (16 bar) / PN25 / PN40</li>
<li>Torrino: pelo libero +6m sopra la livelletta</li>
<li>Turbina: salto = margine residuo all'arrivo</li>
</ul>
</div>
</div>

<!-- TOPBAR -->
<div class="top">
<h1 onclick="openHelp()">❓ GAA OptiTrace</h1>
<span class="pill ok">Punti: <b id="sN">0</b></span>
<span class="pill">Dist: <b id="sD">0</b> km</span>
<span class="pill">Quota: <b id="sQ">340→146</b></span>
<span class="pill" id="pViola">Violaz KML: <b id="sV">0</b></span>
<span class="pill warn">P.max: <b id="sP">0</b> bar</span>
<span class="pill ok">Piez→: <b id="sPz">0</b>m</span>
<span class="pill ok">Margine: <b id="sM">0</b>m</span>
<span class="pill">🔵 Turbina: <b id="sTu">0</b> MW</span>
<span class="pill">Scenari: 
<select id="selScen" onchange="setScenario(this.value)" style="background:#0c2d57;color:#e2e8f0;border:1px solid #1e3a5f;border-radius:3px;font-size:11px">
<option value="0">Senza torrini</option>
<option value="2" selected>Con 2 torrini</option>
</select></span>
</div>

<!-- MAIN -->
<div class="wrap">
<div id="map"></div>
<div class="side">
<div class="tabs">
<div class="tab on" data-t="profilo">📈 Profilo</div>
<div class="tab" data-t="tabella">📋 Dati</div>
<div class="tab" data-t="analisi">📊 Analisi</div>
<div class="tab" data-t="config">⚙️</div>
</div>

<div class="tp on" id="profilo">
<div class="leg">
<div class="li"><div class="lc" style="background:#8B7355"></div>Terreno DEM</div>
<div class="li"><div class="lc" style="background:#3b82f6"></div>Livelletta KML</div>
<div class="li"><div class="lc" style="background:#ef4444"></div>Piezometrica</div>
<div class="li"><div class="lc" style="background:#a855f7"></div>Torrino</div>
<div class="li"><div class="lc" style="background:rgba(239,68,68,0.15)"></div>Trincea</div>
</div>
<canvas id="c1" height="230"></canvas>
<canvas id="c2" height="190"></canvas>
<div style="font-size:10px;color:#475569;padding:2px">Trascina sopra per zoomare · Clicca sotto per centrare mappa · <span style="color:var(--accent);cursor:pointer" onclick="openHelp()">❓ Guida</span></div>
</div>

<div class="tp" id="tabella">
<div style="padding:4px;display:flex;gap:4px;flex-wrap:wrap">
<button class="btn w" onclick="saveToPHP()">💿 Salva DB</button>
<button class="btn g" onclick="saveSnap()">📸 Snapshot</button>
<button class="btn" onclick="loadSnap()">📂 Carica</button>
<button class="btn p" onclick="exportKML()">🌍 KML</button>
</div>
<table>
<thead><tr><th>#</th><th>km</th><th>DEM</th><th>KML</th><th>Piez</th><th>Marg</th><th>bar</th><th>PN</th><th>Trinc</th><th>Tipo</th></tr></thead>
<tbody id="tb"></tbody>
</table>
</div>

<div class="tp" id="analisi">
<div id="anContent"></div>
</div>

<div class="tp" id="config">
<div class="cd">
<h3>📐 Parametri</h3>
<p>Perdite: <input type="number" id="iPerd" value="0.28" step="0.01" style="width:60px;background:var(--bg);color:#fff;border:1px solid var(--border);padding:2px 4px;border-radius:3px"> m/km</p>
<p>Quota partenza: <input type="number" id="iStart" value="340" style="width:60px;background:var(--bg);color:#fff;border:1px solid var(--border);padding:2px 4px;border-radius:3px"> m</p>
<p>H torrino: <input type="number" id="iHtor" value="6" style="width:50px;background:var(--bg);color:#fff;border:1px solid var(--border);padding:2px 4px;border-radius:3px"> m</p>
<p style="margin-top:8px"><button class="btn" onclick="recalc()">🔄 Ricalcola</button></p>
</div>
<div class="cd">
<h3>🗺️ Mappa</h3>
<button class="btn" onclick="M.setMapTypeId('terrain')">🏔️ Terrain</button>
<button class="btn" onclick="M.setMapTypeId('satellite')">🛰️ Satellite</button>
<button class="btn" onclick="M.setMapTypeId('hybrid')">🗺️ Hybrid</button>
</div>
<div class="cd">
<h3>📊 Riepilogo sistema</h3>
<div id="summary"></div>
</div>
</div>
</div>
</div>

<script>
const AK="AIzaSyBs_NQi-rFZD_3SAe4NgFa2fU6N-SXgcJU";
const WP=[{"id": 1, "idx": 0, "lat": 42.2687956334957, "lon": 13.79227288261203, "kml": 340.0, "dem": 329.3, "km": 0.0, "piez": 340, "marg": 0.0, "bar": 0, "pn": "PN16", "tipo": "presa", "trincea": 0, "piez_t": 340, "marg_t": 0.0}, {"id": 2, "idx": 1, "lat": 42.265, "lon": 13.795, "kml": 327.0, "dem": 337.2, "km": 0.48, "piez": 339.9, "marg": 12.9, "bar": 1.3, "pn": "PN16", "tipo": "condotta", "trincea": 10.0, "piez_t": 339.9, "marg_t": 12.9}, {"id": 3, "idx": 2, "lat": 42.253, "lon": 13.802, "kml": 326.0, "dem": 324.7, "km": 1.93, "piez": 339.5, "marg": 13.5, "bar": 1.3, "pn": "PN16", "tipo": "condotta", "trincea": 0, "piez_t": 339.5, "marg_t": 13.5}, {"id": 4, "idx": 3, "lat": 42.24453551533435, "lon": 13.80737107776118, "kml": 320.5, "dem": 327.4, "km": 2.97, "piez": 339.2, "marg": 18.7, "bar": 1.8, "pn": "PN16", "tipo": "condotta", "trincea": 7.0, "piez_t": 339.2, "marg_t": 18.7}, {"id": 5, "idx": 4, "lat": 42.24203577912249, "lon": 13.81059695266732, "kml": 317.8, "dem": 328.1, "km": 3.36, "piez": 339.1, "marg": 21.3, "bar": 2.1, "pn": "PN16", "tipo": "condotta", "trincea": 10.0, "piez_t": 339.1, "marg_t": 21.3}, {"id": 6, "idx": 5, "lat": 42.24090743270912, "lon": 13.8136971247932, "kml": 316.4, "dem": 318.6, "km": 3.64, "piez": 339.0, "marg": 22.6, "bar": 2.2, "pn": "PN16", "tipo": "condotta", "trincea": 2.0, "piez_t": 339.0, "marg_t": 22.6}, {"id": 7, "idx": 6, "lat": 42.23326904431615, "lon": 13.81588171854012, "kml": 315.7, "dem": 316.8, "km": 4.51, "piez": 338.7, "marg": 23.1, "bar": 2.3, "pn": "PN16", "tipo": "condotta", "trincea": 1.0, "piez_t": 338.7, "marg_t": 23.1}, {"id": 8, "idx": 7, "lat": 42.22508062763393, "lon": 13.81738959509464, "kml": 315.0, "dem": 316.9, "km": 5.43, "piez": 338.5, "marg": 23.5, "bar": 2.3, "pn": "PN16", "tipo": "torrino", "trincea": 2.0, "piez_t": 321.0, "marg_t": 6.0}, {"id": 9, "idx": 8, "lat": 42.21837377115907, "lon": 13.81979807887719, "kml": 290.0, "dem": 316.3, "km": 6.2, "piez": 338.3, "marg": 48.3, "bar": 4.7, "pn": "PN16", "tipo": "condotta", "trincea": 26.0, "piez_t": 320.8, "marg_t": 30.8}, {"id": 10, "idx": 9, "lat": 42.21243954813367, "lon": 13.82346667802687, "kml": 272.5, "dem": 313.5, "km": 6.92, "piez": 338.1, "marg": 65.6, "bar": 6.4, "pn": "PN16", "tipo": "condotta", "trincea": 41.0, "piez_t": 320.6, "marg_t": 48.1}, {"id": 11, "idx": 10, "lat": 42.21035453513785, "lon": 13.82437159659409, "kml": 255.0, "dem": 309.9, "km": 7.17, "piez": 338.0, "marg": 83.0, "bar": 8.1, "pn": "PN16", "tipo": "condotta", "trincea": 55.0, "piez_t": 320.5, "marg_t": 65.5}, {"id": 12, "idx": 11, "lat": 42.20834595413841, "lon": 13.82592180447997, "kml": 251.5, "dem": 305.6, "km": 7.43, "piez": 337.9, "marg": 86.4, "bar": 8.5, "pn": "PN16", "tipo": "condotta", "trincea": 54.0, "piez_t": 320.4, "marg_t": 68.9}, {"id": 13, "idx": 12, "lat": 42.20681266102179, "lon": 13.82793636220127, "kml": 249.8, "dem": 278.6, "km": 7.66, "piez": 337.9, "marg": 88.1, "bar": 8.6, "pn": "PN16", "tipo": "condotta", "trincea": 29.0, "piez_t": 320.4, "marg_t": 70.6}, {"id": 14, "idx": 13, "lat": 42.20566646535141, "lon": 13.83274066128941, "kml": 248.9, "dem": 256.7, "km": 8.08, "piez": 337.7, "marg": 88.9, "bar": 8.7, "pn": "PN16", "tipo": "condotta", "trincea": 8.0, "piez_t": 320.3, "marg_t": 71.4}, {"id": 15, "idx": 14, "lat": 42.20399719784053, "lon": 13.83683551110927, "kml": 248.4, "dem": 248.5, "km": 8.46, "piez": 337.6, "marg": 89.2, "bar": 8.7, "pn": "PN16", "tipo": "condotta", "trincea": 0.0, "piez_t": 320.1, "marg_t": 71.7}, {"id": 16, "idx": 15, "lat": 42.20099717726809, "lon": 13.83843610534277, "kml": 248.0, "dem": 250.5, "km": 8.82, "piez": 337.5, "marg": 89.5, "bar": 8.8, "pn": "PN16", "tipo": "condotta", "trincea": 2.0, "piez_t": 320.0, "marg_t": 72.0}, {"id": 17, "idx": 16, "lat": 42.19835715317564, "lon": 13.83966320931086, "kml": 241.0, "dem": 257.4, "km": 9.13, "piez": 337.4, "marg": 96.4, "bar": 9.5, "pn": "PN16", "tipo": "condotta", "trincea": 16.0, "piez_t": 320.0, "marg_t": 79.0}, {"id": 18, "idx": 17, "lat": 42.19768282078385, "lon": 13.84179532714515, "kml": 226.5, "dem": 246.8, "km": 9.32, "piez": 337.4, "marg": 110.9, "bar": 10.9, "pn": "PN16", "tipo": "condotta", "trincea": 20.0, "piez_t": 319.9, "marg_t": 93.4}, {"id": 19, "idx": 18, "lat": 42.19840754331267, "lon": 13.84618044170224, "kml": 219.3, "dem": 241.6, "km": 9.69, "piez": 337.3, "marg": 118.0, "bar": 11.6, "pn": "PN16", "tipo": "condotta", "trincea": 22.0, "piez_t": 319.8, "marg_t": 100.6}, {"id": 20, "idx": 19, "lat": 42.19816824480178, "lon": 13.84752618703511, "kml": 215.6, "dem": 241.6, "km": 9.81, "piez": 337.3, "marg": 121.6, "bar": 11.9, "pn": "PN16", "tipo": "condotta", "trincea": 26.0, "piez_t": 319.8, "marg_t": 104.1}, {"id": 21, "idx": 20, "lat": 42.19683700438253, "lon": 13.84973762980744, "kml": 213.8, "dem": 241.7, "km": 10.04, "piez": 337.2, "marg": 123.4, "bar": 12.1, "pn": "PN16", "tipo": "condotta", "trincea": 28.0, "piez_t": 319.7, "marg_t": 105.9}, {"id": 22, "idx": 21, "lat": 42.19547946387443, "lon": 13.85067517250251, "kml": 212.9, "dem": 241.5, "km": 10.21, "piez": 337.1, "marg": 124.2, "bar": 12.2, "pn": "PN16", "tipo": "condotta", "trincea": 29.0, "piez_t": 319.7, "marg_t": 106.8}, {"id": 23, "idx": 22, "lat": 42.19478393069467, "lon": 13.85211474238234, "kml": 212.5, "dem": 238.5, "km": 10.35, "piez": 337.1, "marg": 124.6, "bar": 12.2, "pn": "PN16", "tipo": "condotta", "trincea": 26.0, "piez_t": 319.6, "marg_t": 107.2}, {"id": 24, "idx": 23, "lat": 42.19621439910465, "lon": 13.85411491428344, "kml": 212.2, "dem": 237.5, "km": 10.58, "piez": 337.0, "marg": 124.8, "bar": 12.2, "pn": "PN16", "tipo": "condotta", "trincea": 25.0, "piez_t": 319.6, "marg_t": 107.3}, {"id": 25, "idx": 24, "lat": 42.197755610531, "lon": 13.87169945324673, "kml": 212.1, "dem": 231.1, "km": 12.04, "piez": 336.6, "marg": 124.5, "bar": 12.2, "pn": "PN16", "tipo": "condotta", "trincea": 19.0, "piez_t": 319.1, "marg_t": 107.0}, {"id": 26, "idx": 25, "lat": 42.19905373994171, "lon": 13.88020744353385, "kml": 212.1, "dem": 232.2, "km": 12.76, "piez": 336.4, "marg": 124.4, "bar": 12.2, "pn": "PN16", "tipo": "condotta", "trincea": 20.0, "piez_t": 318.9, "marg_t": 106.9}, {"id": 27, "idx": 26, "lat": 42.20237460087529, "lon": 13.88716412521487, "kml": 212.0, "dem": 217.4, "km": 13.44, "piez": 336.2, "marg": 124.2, "bar": 12.2, "pn": "PN16", "tipo": "condotta", "trincea": 5.0, "piez_t": 318.8, "marg_t": 106.7}, {"id": 28, "idx": 27, "lat": 42.21, "lon": 13.894, "kml": 212.0, "dem": 189.8, "km": 14.46, "piez": 336.0, "marg": 124.0, "bar": 12.2, "pn": "PN16", "tipo": "condotta", "trincea": 0, "piez_t": 318.5, "marg_t": 106.5}, {"id": 29, "idx": 28, "lat": 42.22551005085146, "lon": 13.9098213840648, "kml": 175.0, "dem": 187.3, "km": 16.62, "piez": 335.3, "marg": 160.3, "bar": 15.7, "pn": "PN16", "tipo": "condotta", "trincea": 12.0, "piez_t": 317.9, "marg_t": 142.9}, {"id": 30, "idx": 29, "lat": 42.2319640061735, "lon": 13.92898058174838, "kml": 165.0, "dem": 182.5, "km": 18.35, "piez": 334.9, "marg": 169.9, "bar": 16.7, "pn": "PN25", "tipo": "condotta", "trincea": 17.0, "piez_t": 317.4, "marg_t": 152.4}, {"id": 31, "idx": 30, "lat": 42.23479196622368, "lon": 13.93850673939297, "kml": 160.0, "dem": 235.2, "km": 19.2, "piez": 334.6, "marg": 174.6, "bar": 17.1, "pn": "PN25", "tipo": "condotta", "trincea": 75.0, "piez_t": 317.1, "marg_t": 157.1}, {"id": 32, "idx": 31, "lat": 42.243, "lon": 13.946, "kml": 155.0, "dem": 155.3, "km": 20.3, "piez": 334.3, "marg": 179.3, "bar": 17.6, "pn": "PN25", "tipo": "condotta", "trincea": 0.0, "piez_t": 316.8, "marg_t": 161.8}, {"id": 33, "idx": 32, "lat": 42.24695942084983, "lon": 13.95027632275994, "kml": 123.0, "dem": 145.4, "km": 20.86, "piez": 334.2, "marg": 211.2, "bar": 20.7, "pn": "PN25", "tipo": "condotta", "trincea": 22.0, "piez_t": 316.7, "marg_t": 193.7}, {"id": 34, "idx": 33, "lat": 42.25378492874483, "lon": 13.9517675748076, "kml": 121.0, "dem": 135.3, "km": 21.63, "piez": 333.9, "marg": 212.9, "bar": 20.9, "pn": "PN25", "tipo": "condotta", "trincea": 14.0, "piez_t": 316.5, "marg_t": 195.5}, {"id": 35, "idx": 34, "lat": 42.259927682443, "lon": 13.95870087610025, "kml": 120.0, "dem": 164.5, "km": 22.52, "piez": 333.7, "marg": 213.7, "bar": 21.0, "pn": "PN25", "tipo": "condotta", "trincea": 44.0, "piez_t": 316.2, "marg_t": 196.2}, {"id": 36, "idx": 35, "lat": 42.26155671121086, "lon": 13.96048069723884, "kml": 119.0, "dem": 154.1, "km": 22.75, "piez": 333.6, "marg": 214.6, "bar": 21.0, "pn": "PN25", "tipo": "condotta", "trincea": 35.0, "piez_t": 316.1, "marg_t": 197.1}, {"id": 37, "idx": 36, "lat": 42.26487546549514, "lon": 13.96236888736254, "kml": 117.0, "dem": 116.1, "km": 23.15, "piez": 333.5, "marg": 216.5, "bar": 21.2, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 316.0, "marg_t": 199.0}, {"id": 38, "idx": 37, "lat": 42.27, "lon": 13.984, "kml": 115.0, "dem": 106.2, "km": 25.02, "piez": 333.0, "marg": 218.0, "bar": 21.4, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 315.5, "marg_t": 200.5}, {"id": 39, "idx": 38, "lat": 42.27055013925131, "lon": 13.98916285243334, "kml": 100.0, "dem": 113.6, "km": 25.45, "piez": 332.9, "marg": 232.9, "bar": 22.8, "pn": "PN25", "tipo": "condotta", "trincea": 14.0, "piez_t": 315.4, "marg_t": 215.4}, {"id": 40, "idx": 39, "lat": 42.27212693687289, "lon": 13.99763498825689, "kml": 92.5, "dem": 113.1, "km": 26.17, "piez": 332.7, "marg": 240.2, "bar": 23.5, "pn": "PN25", "tipo": "condotta", "trincea": 21.0, "piez_t": 315.2, "marg_t": 222.7}, {"id": 41, "idx": 40, "lat": 42.27375386987421, "lon": 14.00468287472412, "kml": 88.8, "dem": 115.3, "km": 26.78, "piez": 332.5, "marg": 243.8, "bar": 23.9, "pn": "PN25", "tipo": "condotta", "trincea": 27.0, "piez_t": 315.0, "marg_t": 226.3}, {"id": 42, "idx": 41, "lat": 42.27507999514177, "lon": 14.00626751115825, "kml": 85.0, "dem": 121.7, "km": 26.98, "piez": 332.4, "marg": 247.4, "bar": 24.3, "pn": "PN25", "tipo": "condotta", "trincea": 37.0, "piez_t": 315.0, "marg_t": 230.0}, {"id": 43, "idx": 42, "lat": 42.27793072961725, "lon": 14.00909067413409, "kml": 75.8, "dem": 136.9, "km": 27.37, "piez": 332.3, "marg": 256.6, "bar": 25.2, "pn": "PN40", "tipo": "condotta", "trincea": 61.0, "piez_t": 314.9, "marg_t": 239.1}, {"id": 44, "idx": 43, "lat": 42.27699515066612, "lon": 14.01318513267579, "kml": 71.1, "dem": 94.5, "km": 27.72, "piez": 332.2, "marg": 261.1, "bar": 25.6, "pn": "PN40", "tipo": "condotta", "trincea": 23.0, "piez_t": 314.8, "marg_t": 243.6}, {"id": 45, "idx": 44, "lat": 42.27875283748378, "lon": 14.01517785311117, "kml": 68.8, "dem": 91.0, "km": 27.98, "piez": 332.2, "marg": 263.4, "bar": 25.8, "pn": "PN40", "tipo": "condotta", "trincea": 22.0, "piez_t": 314.7, "marg_t": 245.9}, {"id": 46, "idx": 45, "lat": 42.27960490545341, "lon": 14.01797012609048, "kml": 66.5, "dem": 82.4, "km": 28.22, "piez": 332.1, "marg": 265.6, "bar": 26.0, "pn": "PN40", "tipo": "condotta", "trincea": 16.0, "piez_t": 314.6, "marg_t": 248.1}, {"id": 47, "idx": 46, "lat": 42.27999542073985, "lon": 14.01995303853431, "kml": 57.2, "dem": 79.7, "km": 28.39, "piez": 332.0, "marg": 274.8, "bar": 26.9, "pn": "PN40", "tipo": "condotta", "trincea": 22.0, "piez_t": 314.6, "marg_t": 257.3}, {"id": 48, "idx": 47, "lat": 42.28196101487242, "lon": 14.02212413321666, "kml": 52.6, "dem": 78.7, "km": 28.68, "piez": 332.0, "marg": 279.3, "bar": 27.4, "pn": "PN40", "tipo": "condotta", "trincea": 26.0, "piez_t": 314.5, "marg_t": 261.9}, {"id": 49, "idx": 48, "lat": 42.29965869766803, "lon": 14.03767617464687, "kml": 50.3, "dem": 68.0, "km": 31.02, "piez": 331.3, "marg": 281.0, "bar": 27.5, "pn": "PN40", "tipo": "condotta", "trincea": 18.0, "piez_t": 313.8, "marg_t": 263.5}, {"id": 50, "idx": 49, "lat": 42.32064314726232, "lon": 14.06327989384748, "kml": 48.0, "dem": 54.7, "km": 34.17, "piez": 330.4, "marg": 282.4, "bar": 27.7, "pn": "PN40", "tipo": "condotta", "trincea": 7.0, "piez_t": 313.0, "marg_t": 265.0}, {"id": 51, "idx": 50, "lat": 42.33571447294579, "lon": 14.07816027591422, "kml": 52.5, "dem": 51.9, "km": 36.24, "piez": 329.9, "marg": 277.4, "bar": 27.2, "pn": "PN40", "tipo": "condotta", "trincea": 0, "piez_t": 312.4, "marg_t": 259.9}, {"id": 52, "idx": 51, "lat": 42.34222186961515, "lon": 14.08616786267349, "kml": 54.7, "dem": 89.8, "km": 37.22, "piez": 329.6, "marg": 274.8, "bar": 26.9, "pn": "PN40", "tipo": "condotta", "trincea": 35.0, "piez_t": 312.1, "marg_t": 257.3}, {"id": 53, "idx": 52, "lat": 42.34479413959946, "lon": 14.08813748082699, "kml": 55.9, "dem": 109.2, "km": 37.55, "piez": 329.5, "marg": 273.6, "bar": 26.8, "pn": "PN40", "tipo": "condotta", "trincea": 53.0, "piez_t": 312.0, "marg_t": 256.1}, {"id": 54, "idx": 53, "lat": 42.34405410473646, "lon": 14.09158503564867, "kml": 57.0, "dem": 82.3, "km": 37.84, "piez": 329.4, "marg": 272.4, "bar": 26.7, "pn": "PN40", "tipo": "condotta", "trincea": 25.0, "piez_t": 311.9, "marg_t": 254.9}, {"id": 55, "idx": 54, "lat": 42.34224121872714, "lon": 14.10597819820138, "kml": 46.5, "dem": 52.2, "km": 39.04, "piez": 329.1, "marg": 282.6, "bar": 27.7, "pn": "PN40", "tipo": "condotta", "trincea": 6.0, "piez_t": 311.6, "marg_t": 265.1}, {"id": 56, "idx": 55, "lat": 42.34036910291672, "lon": 14.10968429764022, "kml": 41.2, "dem": 50.1, "km": 39.41, "piez": 329.0, "marg": 287.7, "bar": 28.2, "pn": "PN40", "tipo": "condotta", "trincea": 9.0, "piez_t": 311.5, "marg_t": 270.2}, {"id": 57, "idx": 56, "lat": 42.33632366125016, "lon": 14.1224588702114, "kml": 36.0, "dem": 36.7, "km": 40.55, "piez": 328.6, "marg": 292.6, "bar": 28.7, "pn": "PN40", "tipo": "condotta", "trincea": 1.0, "piez_t": 311.2, "marg_t": 275.2}, {"id": 58, "idx": 57, "lat": 42.33398524480023, "lon": 14.12854041927788, "kml": 63.0, "dem": 52.6, "km": 41.12, "piez": 328.5, "marg": 265.5, "bar": 26.0, "pn": "PN40", "tipo": "condotta", "trincea": 0, "piez_t": 311.0, "marg_t": 248.0}, {"id": 59, "idx": 58, "lat": 42.33388962370644, "lon": 14.13087848076999, "kml": 76.5, "dem": 53.9, "km": 41.31, "piez": 328.4, "marg": 251.9, "bar": 24.7, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 311.0, "marg_t": 234.5}, {"id": 60, "idx": 59, "lat": 42.33427153796327, "lon": 14.13300270441054, "kml": 83.2, "dem": 65.0, "km": 41.49, "piez": 328.4, "marg": 245.1, "bar": 24.0, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 310.9, "marg_t": 227.7}, {"id": 61, "idx": 60, "lat": 42.33290714441252, "lon": 14.13506489004265, "kml": 86.6, "dem": 83.2, "km": 41.72, "piez": 328.3, "marg": 241.7, "bar": 23.7, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 310.8, "marg_t": 224.2}, {"id": 62, "idx": 61, "lat": 42.33105357399239, "lon": 14.14067177006906, "kml": 88.3, "dem": 139.8, "km": 42.22, "piez": 328.2, "marg": 239.9, "bar": 23.5, "pn": "PN25", "tipo": "condotta", "trincea": 52.0, "piez_t": 310.7, "marg_t": 222.4}, {"id": 63, "idx": 62, "lat": 42.33008327286715, "lon": 14.14375900738293, "kml": 89.2, "dem": 205.8, "km": 42.5, "piez": 328.1, "marg": 238.9, "bar": 23.4, "pn": "PN25", "tipo": "condotta", "trincea": 117.0, "piez_t": 310.6, "marg_t": 221.5}, {"id": 64, "idx": 63, "lat": 42.32767546483229, "lon": 14.14603508506272, "kml": 89.6, "dem": 164.4, "km": 42.82, "piez": 328.0, "marg": 238.4, "bar": 23.4, "pn": "PN25", "tipo": "condotta", "trincea": 75.0, "piez_t": 310.5, "marg_t": 221.0}, {"id": 65, "idx": 64, "lat": 42.32699610105099, "lon": 14.14862919946045, "kml": 89.8, "dem": 200.8, "km": 43.05, "piez": 327.9, "marg": 238.2, "bar": 23.3, "pn": "PN25", "tipo": "condotta", "trincea": 111.0, "piez_t": 310.5, "marg_t": 220.7}, {"id": 66, "idx": 65, "lat": 42.32629364966657, "lon": 14.15153061523449, "kml": 89.9, "dem": 284.0, "km": 43.3, "piez": 327.9, "marg": 238.0, "bar": 23.3, "pn": "PN25", "tipo": "condotta", "trincea": 194.0, "piez_t": 310.4, "marg_t": 220.5}, {"id": 67, "idx": 66, "lat": 42.32680200476724, "lon": 14.1543816931871, "kml": 89.9, "dem": 283.5, "km": 43.54, "piez": 327.8, "marg": 237.9, "bar": 23.3, "pn": "PN25", "tipo": "condotta", "trincea": 194.0, "piez_t": 310.3, "marg_t": 220.4}, {"id": 68, "idx": 67, "lat": 42.32703499729301, "lon": 14.1584377925958, "kml": 90.0, "dem": 267.9, "km": 43.88, "piez": 327.7, "marg": 237.7, "bar": 23.3, "pn": "PN25", "tipo": "condotta", "trincea": 178.0, "piez_t": 310.2, "marg_t": 220.3}, {"id": 69, "idx": 68, "lat": 42.32714359959662, "lon": 14.16296568105981, "kml": 90.0, "dem": 251.1, "km": 44.25, "piez": 327.6, "marg": 237.6, "bar": 23.3, "pn": "PN25", "tipo": "condotta", "trincea": 161.0, "piez_t": 310.1, "marg_t": 220.1}, {"id": 70, "idx": 69, "lat": 42.315, "lon": 14.175, "kml": 90.0, "dem": 87.0, "km": 45.92, "piez": 327.1, "marg": 237.1, "bar": 23.2, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 309.7, "marg_t": 219.7}, {"id": 71, "idx": 70, "lat": 42.295, "lon": 14.215, "kml": 133.0, "dem": 132.4, "km": 49.89, "piez": 326.0, "marg": 193.0, "bar": 18.9, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 308.5, "marg_t": 175.5}, {"id": 72, "idx": 71, "lat": 42.26, "lon": 14.225, "kml": 165.0, "dem": 168.6, "km": 53.87, "piez": 324.9, "marg": 159.9, "bar": 15.7, "pn": "PN16", "tipo": "condotta", "trincea": 4.0, "piez_t": 307.4, "marg_t": 142.4}, {"id": 73, "idx": 72, "lat": 42.24082552880738, "lon": 14.25016968608427, "kml": 255.0, "dem": 388.5, "km": 56.84, "piez": 324.1, "marg": 69.1, "bar": 6.8, "pn": "PN16", "tipo": "condotta", "trincea": 134.0, "piez_t": 306.6, "marg_t": 51.6}, {"id": 74, "idx": 73, "lat": 42.24344668371312, "lon": 14.2846345687277, "kml": 240.5, "dem": 344.7, "km": 59.7, "piez": 323.3, "marg": 82.8, "bar": 8.1, "pn": "PN16", "tipo": "condotta", "trincea": 104.0, "piez_t": 305.8, "marg_t": 65.3}, {"id": 75, "idx": 74, "lat": 42.24346432015006, "lon": 14.30485273995109, "kml": 226.0, "dem": 319.9, "km": 61.36, "piez": 322.8, "marg": 96.8, "bar": 9.5, "pn": "PN16", "tipo": "condotta", "trincea": 94.0, "piez_t": 305.3, "marg_t": 79.3}, {"id": 76, "idx": 75, "lat": 42.23474465341314, "lon": 14.3207478560398, "kml": 183.5, "dem": 267.4, "km": 62.99, "piez": 322.4, "marg": 138.9, "bar": 13.6, "pn": "PN16", "tipo": "condotta", "trincea": 84.0, "piez_t": 304.9, "marg_t": 121.4}, {"id": 77, "idx": 76, "lat": 42.2096831280923, "lon": 14.32908103567808, "kml": 162.2, "dem": 159.3, "km": 65.86, "piez": 321.6, "marg": 159.3, "bar": 15.6, "pn": "PN16", "tipo": "condotta", "trincea": 0, "piez_t": 304.1, "marg_t": 141.8}, {"id": 78, "idx": 77, "lat": 42.15536171259227, "lon": 14.33062191183429, "kml": 141.0, "dem": 141.6, "km": 71.9, "piez": 319.9, "marg": 178.9, "bar": 17.5, "pn": "PN25", "tipo": "condotta", "trincea": 1.0, "piez_t": 302.4, "marg_t": 161.4}, {"id": 79, "idx": 78, "lat": 42.12, "lon": 14.375, "kml": 86.0, "dem": 91.3, "km": 77.27, "piez": 318.4, "marg": 232.4, "bar": 22.8, "pn": "PN25", "tipo": "condotta", "trincea": 5.0, "piez_t": 300.9, "marg_t": 214.9}, {"id": 80, "idx": 79, "lat": 42.115, "lon": 14.385, "kml": 89.0, "dem": 91.9, "km": 78.27, "piez": 318.1, "marg": 229.1, "bar": 22.5, "pn": "PN25", "tipo": "condotta", "trincea": 3.0, "piez_t": 300.6, "marg_t": 211.6}, {"id": 81, "idx": 80, "lat": 42.085, "lon": 14.455, "kml": 204.0, "dem": 212.0, "km": 84.94, "piez": 316.2, "marg": 112.2, "bar": 11.0, "pn": "PN16", "tipo": "condotta", "trincea": 8.0, "piez_t": 298.7, "marg_t": 94.7}, {"id": 82, "idx": 81, "lat": 42.03, "lon": 14.515, "kml": 239.0, "dem": 232.0, "km": 92.81, "piez": 314.0, "marg": 75.0, "bar": 7.4, "pn": "PN16", "tipo": "condotta", "trincea": 0, "piez_t": 296.5, "marg_t": 57.5}, {"id": 83, "idx": 82, "lat": 42.025, "lon": 14.56, "kml": 259.0, "dem": 254.8, "km": 96.56, "piez": 313.0, "marg": 54.0, "bar": 5.3, "pn": "PN16", "tipo": "torrino", "trincea": 0, "piez_t": 265.0, "marg_t": 6.0}, {"id": 84, "idx": 83, "lat": 41.965, "lon": 14.665, "kml": 122.0, "dem": 116.7, "km": 107.51, "piez": 309.9, "marg": 187.9, "bar": 18.4, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 261.9, "marg_t": 139.9}, {"id": 85, "idx": 84, "lat": 41.965, "lon": 14.75, "kml": 113.0, "dem": 123.7, "km": 114.54, "piez": 307.9, "marg": 194.9, "bar": 19.1, "pn": "PN25", "tipo": "condotta", "trincea": 11.0, "piez_t": 260.0, "marg_t": 147.0}, {"id": 86, "idx": 85, "lat": 41.935, "lon": 14.865, "kml": 89.0, "dem": 88.1, "km": 124.62, "piez": 305.1, "marg": 216.1, "bar": 21.2, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 257.1, "marg_t": 168.1}, {"id": 87, "idx": 86, "lat": 41.9, "lon": 14.93, "kml": 59.0, "dem": 39.9, "km": 131.25, "piez": 303.2, "marg": 244.2, "bar": 23.9, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 255.3, "marg_t": 196.3}, {"id": 88, "idx": 87, "lat": 41.88, "lon": 14.96, "kml": 75.0, "dem": 74.9, "km": 134.59, "piez": 302.3, "marg": 227.3, "bar": 22.3, "pn": "PN25", "tipo": "condotta", "trincea": 0, "piez_t": 254.4, "marg_t": 179.4}, {"id": 89, "idx": 88, "lat": 41.85, "lon": 15.0, "kml": 155.0, "dem": 141.1, "km": 139.29, "piez": 301.0, "marg": 146.0, "bar": 14.3, "pn": "PN16", "tipo": "condotta", "trincea": 0, "piez_t": 253.0, "marg_t": 98.0}, {"id": 90, "idx": 89, "lat": 41.82, "lon": 15.03, "kml": 200.0, "dem": 201.7, "km": 143.45, "piez": 299.8, "marg": 99.8, "bar": 9.8, "pn": "PN16", "tipo": "condotta", "trincea": 2.0, "piez_t": 251.9, "marg_t": 51.9}, {"id": 91, "idx": 90, "lat": 41.78, "lon": 15.06, "kml": 169.0, "dem": 169.5, "km": 148.55, "piez": 298.4, "marg": 129.4, "bar": 12.7, "pn": "PN16", "tipo": "condotta", "trincea": 1.0, "piez_t": 250.4, "marg_t": 81.4}, {"id": 92, "idx": 91, "lat": 41.75, "lon": 15.1, "kml": 188.0, "dem": 197.0, "km": 153.25, "piez": 297.1, "marg": 109.1, "bar": 10.7, "pn": "PN16", "tipo": "condotta", "trincea": 9.0, "piez_t": 249.1, "marg_t": 61.1}, {"id": 93, "idx": 92, "lat": 41.71, "lon": 15.13, "kml": 114.0, "dem": 114.1, "km": 158.35, "piez": 295.7, "marg": 181.7, "bar": 17.8, "pn": "PN25", "tipo": "condotta", "trincea": 0.0, "piez_t": 247.7, "marg_t": 133.7}, {"id": 94, "idx": 93, "lat": 41.68, "lon": 15.15, "kml": 132.0, "dem": 132.1, "km": 162.07, "piez": 294.6, "marg": 162.6, "bar": 15.9, "pn": "PN16", "tipo": "condotta", "trincea": 0.0, "piez_t": 246.7, "marg_t": 114.7}, {"id": 95, "idx": 94, "lat": 41.6523, "lon": 15.1643, "kml": 146.0, "dem": 146.5, "km": 165.37, "piez": 293.7, "marg": 147.7, "bar": 14.5, "pn": "PN16", "tipo": "arrivo", "trincea": 1.0, "piez_t": 245.7, "marg_t": 99.7}];
let scenario=2; // default: con 2 torrini
let M,mk=[],polyDN25,polyDN22,zR=null;

// Identifica DN2500 (primi ~72km) e DN2200 (resto)
const KM_SWITCH=72; // punto cambio diametro

// TABS
document.querySelectorAll('.tab').forEach(t=>t.onclick=function(){
document.querySelectorAll('.tab,.tp').forEach(x=>x.classList.remove('on'));
this.classList.add('on');document.getElementById(this.dataset.t).classList.add('on');
if(this.dataset.t==='profilo')draw();
});

function hav(a,b){const R=6371e3,dl=Math.PI/180*(b.lat-a.lat),dn=Math.PI/180*(b.lon-a.lon),
x=Math.sin(dl/2)**2+Math.cos(a.lat*Math.PI/180)*Math.cos(b.lat*Math.PI/180)*Math.sin(dn/2)**2;
return R*2*Math.atan2(Math.sqrt(x),Math.sqrt(1-x))}

function openHelp(){document.getElementById('helpModal').classList.add('show')}
function closeHelp(){document.getElementById('helpModal').classList.remove('show')}

function setScenario(v){scenario=parseInt(v);recalc();}

function initMap(){
M=new google.maps.Map(document.getElementById('map'),{
center:{lat:42.0,lng:14.5},zoom:8,mapTypeId:'hybrid',
mapTypeControl:false,streetViewControl:false,fullscreenControl:true,
styles:[{featureType:"poi",stylers:[{visibility:"off"}]}]
});

// DN2500 polyline (primi ~72km)
const dn25pts=WP.filter(p=>p.km<=KM_SWITCH);
const dn22pts=WP.filter(p=>p.km>=KM_SWITCH);
polyDN25=new google.maps.Polyline({path:dn25pts.map(p=>({lat:p.lat,lng:p.lon})),
strokeColor:'#f97316',strokeWeight:4,strokeOpacity:0.85,map:M});
polyDN22=new google.maps.Polyline({path:dn22pts.map(p=>({lat:p.lat,lng:p.lon})),
strokeColor:'#06b6d4',strokeWeight:4,strokeOpacity:0.85,map:M});

// Markers
WP.forEach((p,i)=>{
const m=new google.maps.Marker({position:{lat:p.lat,lng:p.lon},map:M,
icon:mkIcon(p),title:'#'+i+' km'+p.km.toFixed(1)});
const iw=new google.maps.InfoWindow();
m.addListener('click',()=>{
const sc=scenario===2;
const piez=sc?p.piez_t:p.piez;
const marg=sc?p.marg_t:p.marg;
const bar=marg>0?marg/10.2:0;
iw.setContent(`<div style="font-size:11px;min-width:220px;line-height:1.6">
<b style="color:#0ea5e9">#${i} — km ${p.km.toFixed(1)}</b><br>
📍 ${p.lat.toFixed(5)}, ${p.lon.toFixed(5)}<br>
<hr style="border-color:#334155;margin:4px 0">
🏔️ Terreno DEM: <b>${p.dem.toFixed(0)}m</b><br>
📐 Livelletta KML: <b>${p.kml.toFixed(0)}m</b><br>
📉 Piezometrica: <b>${piez.toFixed(0)}m</b><br>
${marg>=0?'✅':'❌'} Margine: <b style="color:${marg>=0?'#22c55e':'#ef4444'}">${marg>0?'+':''}${marg.toFixed(0)}m</b> (${bar.toFixed(1)} bar)<br>
${p.trincea>0?'⛏️ Trincea/galleria: <b>'+p.trincea+'m</b><br>':''}
${p.tipo!=='condotta'?'🏗️ Tipo: <b style="color:#a855f7">'+p.tipo.toUpperCase()+'</b>':''}
</div>`);
iw.open(M,m);});
mk.push(m);
});

recalc();
// Mostra modal al primo accesso
if(!localStorage.getItem('gaa_help_seen')){openHelp();localStorage.setItem('gaa_help_seen','1');}
}

function mkIcon(p){
const isTor=p.tipo==='torrino';
const isPresa=p.tipo==='presa'||p.tipo==='arrivo';
const sc=scenario===2;
const marg=sc?p.marg_t:p.marg;
const isV=marg<0;
const isS=p.trincea>30;
return{path:isTor||isPresa?google.maps.SymbolPath.BACKWARD_CLOSED_ARROW:google.maps.SymbolPath.CIRCLE,
scale:isTor?8:isPresa?7:3,
fillColor:isTor?'#a855f7':isPresa?'#f97316':isV?'#ef4444':isS?'#eab308':'#22c55e',
fillOpacity:0.9,strokeColor:'#fff',strokeWeight:isTor||isPresa?2:0};
}

function recalc(){
const perd=parseFloat(document.getElementById('iPerd').value)||0.28;
const qs=parseFloat(document.getElementById('iStart').value)||340;
const ht=parseFloat(document.getElementById('iHtor').value)||6;
const useTor=scenario===2;

// Identifica torrini
const torIdx=WP.map((p,i)=>p.tipo==='torrino'?i:-1).filter(x=>x>=0);

let piez=qs,viola=0,mp=0,mpKm=0;
const tb=document.getElementById('tb');tb.innerHTML='';

WP.forEach((p,i)=>{
if(i>0){const d=p.km-WP[i-1].km;piez-=d*perd;}
if(useTor&&torIdx.includes(i)){piez=p.kml+ht;} // TORRINO: reset piez
const marg=piez-p.kml;
const bar=marg>0?marg/10.2:0;
const isV=marg<0;
const isS=p.trincea>30;
const isTor=p.tipo==='torrino';
if(isV)viola++;
if(marg>mp){mp=marg;mpKm=p.km;}

// Update dato
p._piez=piez;p._marg=marg;p._bar=bar;
const pn=bar>25?'PN40':bar>16?'PN25':'PN16';

// Tabella
const cls=isTor?'t':isV?'v':isS?'s':'ok';
const tr=document.createElement('tr');tr.className=cls;
tr.innerHTML=`<td>${i}</td><td>${p.km.toFixed(1)}</td><td>${p.dem.toFixed(0)}</td><td>${p.kml.toFixed(0)}</td><td>${piez.toFixed(0)}</td><td>${marg>0?'+':''}${marg.toFixed(0)}</td><td>${bar.toFixed(1)}</td><td>${pn}</td><td>${p.trincea>0?p.trincea+'m':''}</td><td>${p.tipo!=='condotta'?p.tipo:''}</td>`;
tr.onclick=()=>{M.panTo({lat:p.lat,lng:p.lon});M.setZoom(14);};
tb.appendChild(tr);

// Marker icon
if(mk[i])mk[i].setIcon(mkIcon(p));
});

const last=WP[WP.length-1],margF=piez-last.kml;
const turbMW=1e3*9.81*4.8*Math.min(Math.max(margF,0),150)*0.85*0.9/1e6;

document.getElementById('sN').textContent=WP.length;
document.getElementById('sD').textContent=WP[WP.length-1].km.toFixed(1);
document.getElementById('sQ').textContent=qs+'→'+last.kml.toFixed(0);
document.getElementById('sV').textContent=viola;
document.getElementById('pViola').className='pill '+(viola===0?'ok':'err');
document.getElementById('sP').textContent=(mp/10.2).toFixed(0);
document.getElementById('sPz').textContent=piez.toFixed(0);
document.getElementById('sM').textContent=margF.toFixed(0);
document.getElementById('sTu').textContent=turbMW.toFixed(1);

// Analisi
const trinTot=WP.filter(p=>p.trincea>10).length;
const gallTot=WP.filter(p=>p.trincea>50).length;
document.getElementById('anContent').innerHTML=`
<div class="cd ${viola===0?'ok':'err'}">
<h3>${viola===0?'✅ Sistema funzionante a gravità':'❌ Violazioni piezometriche'}</h3>
<p>Violazioni sulla livelletta: <b>${viola}</b></p>
<p>Piez arrivo: <b>${piez.toFixed(0)}m</b></p>
<p>Margine a Finocchito: <b>+${margF.toFixed(0)}m</b></p>
</div>
<div class="cd">
<h3>⚡ Idroelettrico</h3>
<p>Salto disponibile: <b>${Math.min(margF,150).toFixed(0)}m</b></p>
<p>Potenza turbina: <b>${turbMW.toFixed(1)} MW</b></p>
<p>Energia annua: <b>${(turbMW*8000/1000).toFixed(1)} GWh</b> (~€${(turbMW*8000*80/1e3).toFixed(0)}k/anno)</p>
</div>
<div class="cd warn">
<h3>⛏️ Opere civili</h3>
<p>Punti con trincea (&gt;10m DEM sopra KML): <b>${trinTot}</b></p>
<p>Punti con galleria (&gt;50m): <b>${gallTot}</b></p>
<p>Pressione max: <b>${(mp/10.2).toFixed(0)} bar</b> a km ${mpKm.toFixed(0)}</p>
</div>
<div class="cd">
<h3>🔵 Torrini (scenario attuale: ${useTor?'2 torrini':'nessuno'})</h3>
${torIdx.map(ti=>`<p>📍 T${torIdx.indexOf(ti)+1}: km ${WP[ti].km.toFixed(1)}, quota ${WP[ti].kml}m</p>`).join('')}
${torIdx.length===0?'<p>Nessun torrino attivo</p>':''}
</div>
<div class="cd">
<h3>📏 Tratte</h3>
<p>🟠 DN2500: 0 → km ${KM_SWITCH} (${KM_SWITCH} km)</p>
<p>🔵 DN2200: km ${KM_SWITCH} → ${WP[WP.length-1].km.toFixed(0)} (${(WP[WP.length-1].km-KM_SWITCH).toFixed(0)} km)</p>
</div>`;

document.getElementById('summary').innerHTML=`
<p>✅ Violazioni: <b style="color:${viola?'var(--red)':'var(--green)'}">${viola}</b></p>
<p>📏 Distanza: <b>${WP[WP.length-1].km.toFixed(1)} km</b></p>
<p>📉 Piez arrivo: <b>${piez.toFixed(0)}m</b></p>
<p>📊 Margine: <b style="color:var(--green)">+${margF.toFixed(0)}m</b></p>
<p>⚡ Turbina: <b>${turbMW.toFixed(1)} MW</b></p>
<p>💰 Ricavo: <b>~€${(turbMW*8000*80/1e3).toFixed(0)}k/anno</b></p>`;

draw();
}

function draw(){drawC('c1',230,false);if(zR)drawC('c2',190,true);}

function drawC(id,H,isZ){
const cv=document.getElementById(id),ctx=cv.getContext('2d');
const dpr=window.devicePixelRatio||1;cv.width=cv.offsetWidth*dpr;cv.height=H*dpr;
ctx.scale(dpr,dpr);const W=cv.offsetWidth;
ctx.fillStyle='#111827';ctx.fillRect(0,0,W,H);
if(WP.length<2)return;

const pad={l:36,r:8,t:10,b:22};
let fp=isZ?WP.filter(p=>p.km>=zR[0]&&p.km<=zR[1]):WP;
if(fp.length<2)fp=WP;

const mxE=Math.max(...fp.map(p=>Math.max(p.dem,p.kml,p._piez||0)))+30;
const mnK=fp[0].km,mxK=fp[fp.length-1].km;
const xOf=k=>pad.l+(k-mnK)/(mxK-mnK)*(W-pad.l-pad.r);
const yOf=e=>pad.t+(1-e/mxE)*(H-pad.t-pad.b);

// Grid
ctx.strokeStyle='#1e293b';ctx.lineWidth=.5;ctx.fillStyle='#475569';ctx.font='8px sans-serif';
for(let e=0;e<=mxE;e+=50){const y=yOf(e);ctx.beginPath();ctx.moveTo(pad.l,y);ctx.lineTo(W-pad.r,y);ctx.stroke();ctx.fillText(e+'',1,y+3);}
const step=mxK-mnK>100?20:mxK-mnK>40?10:mxK-mnK>15?5:2;
for(let k=Math.ceil(mnK/step)*step;k<=mxK;k+=step){const x=xOf(k);ctx.beginPath();ctx.moveTo(x,pad.t);ctx.lineTo(x,H-pad.b);ctx.stroke();ctx.fillText(k.toFixed(0),x-8,H-pad.b+12);}

// Trincea zones (dove DEM > KML)
fp.forEach((p,i)=>{if(i===0||p.trincea<=10)return;
ctx.fillStyle='rgba(239,68,68,0.08)';
const x1=xOf(fp[Math.max(0,i-1)].km),x2=xOf(p.km);
ctx.fillRect(x1,pad.t,x2-x1,H-pad.t-pad.b);
});

// DN2500/DN2200 background
const xSwitch=xOf(KM_SWITCH);
if(xSwitch>pad.l&&xSwitch<W-pad.r){
ctx.fillStyle='rgba(249,115,22,0.04)';ctx.fillRect(pad.l,pad.t,xSwitch-pad.l,H-pad.t-pad.b);
ctx.fillStyle='rgba(6,182,212,0.04)';ctx.fillRect(xSwitch,pad.t,W-pad.r-xSwitch,H-pad.t-pad.b);
}

// Terreno DEM (fill + line)
ctx.beginPath();ctx.moveTo(xOf(fp[0].km),H-pad.b);
fp.forEach(p=>ctx.lineTo(xOf(p.km),yOf(p.dem)));
ctx.lineTo(xOf(fp[fp.length-1].km),H-pad.b);ctx.closePath();
ctx.fillStyle='rgba(139,115,85,0.2)';ctx.fill();
ctx.beginPath();fp.forEach((p,i)=>{const x=xOf(p.km),y=yOf(p.dem);i?ctx.lineTo(x,y):ctx.moveTo(x,y);});
ctx.strokeStyle='#8B7355';ctx.lineWidth=1.5;ctx.stroke();

// KML livelletta (dashed)
ctx.beginPath();fp.forEach((p,i)=>{const x=xOf(p.km),y=yOf(p.kml);i?ctx.lineTo(x,y):ctx.moveTo(x,y);});
ctx.strokeStyle='#3b82f6';ctx.lineWidth=1.5;ctx.setLineDash([4,3]);ctx.stroke();ctx.setLineDash([]);

// Piezometrica
ctx.beginPath();fp.forEach((p,i)=>{const x=xOf(p.km),y=yOf(p._piez||0);i?ctx.lineTo(x,y):ctx.moveTo(x,y);});
ctx.strokeStyle='#ef4444';ctx.lineWidth=2;ctx.stroke();

// Punti colorati
fp.forEach(p=>{
const x=xOf(p.km),y=yOf(p.kml);
const marg=p._marg||0;
const isTor=p.tipo==='torrino';
ctx.beginPath();ctx.arc(x,y,isTor?5:2,0,Math.PI*2);
ctx.fillStyle=isTor?'#a855f7':marg<0?'#ef4444':'#22c55e';ctx.fill();
if(isTor){ctx.strokeStyle='#fff';ctx.lineWidth=1;ctx.stroke();
ctx.fillStyle='#fff';ctx.font='bold 8px sans-serif';ctx.fillText('T',x-3,y+3);}
});

// Zoom drag (main only)
if(!isZ){
let dr=false,sx=0;
cv.onmousedown=e=>{dr=true;sx=e.offsetX;};
cv.onmouseup=e=>{if(dr&&Math.abs(e.offsetX-sx)>15){
const k1=mnK+(Math.min(sx,e.offsetX)-pad.l)/(W-pad.l-pad.r)*(mxK-mnK);
const k2=mnK+(Math.max(sx,e.offsetX)-pad.l)/(W-pad.l-pad.r)*(mxK-mnK);
zR=[Math.max(k1,0),Math.min(k2,mxK)];drawC('c2',190,true);}dr=false;};
}else{
cv.onclick=e=>{const k=mnK+(e.offsetX-pad.l)/(W-pad.l-pad.r)*(mxK-mnK);
const cl=fp.reduce((b,p)=>Math.abs(p.km-k)<Math.abs(b.km-k)?p:b);
M.panTo({lat:cl.lat,lng:cl.lon});M.setZoom(15);};}
}

function exportKML(){
let k='<'+'?xml version="1.0" encoding="UTF-8"?'+'>\n<kml xmlns="http://www.opengis.net/kml/2.2"><Document><n>GAA OptiTrace</n>';
k+='<Style id="d25"><LineStyle><color>ff0ea5f9</color><width>3</width></LineStyle></Style>';
k+='<Placemark><n>Tracciato</n><styleUrl>#d25</styleUrl><LineString><tessellate>1</tessellate><coordinates>';
WP.forEach(p=>{k+=p.lon+','+p.lat+','+p.kml+' ';});
k+='</coordinates></LineString></Placemark>';
WP.filter(p=>p.tipo!=='condotta').forEach(p=>{
k+='<Placemark><n>'+p.tipo+' km'+p.km.toFixed(1)+'</n><Point><coordinates>'+p.lon+','+p.lat+','+p.kml+'</coordinates></Point></Placemark>';});
k+='</Document></kml>';
const a=document.createElement('a');a.href=URL.createObjectURL(new Blob([k],{type:'application/xml'}));
a.download='GAA_OptiTrace.kml';a.click();}

async function saveToPHP(){
try{
for(const p of WP){
await fetch('api.php?action=update_wp',{method:'POST',headers:{'Content-Type':'application/json'},
body:JSON.stringify({id:p.id,lat:p.lat,lon:p.lon,elev_google:p.dem,tipo:p.tipo,note:''})});}
await fetch('api.php?action=recalc');
alert('✅ Salvato nel database!');
}catch(e){alert('Errore: '+e.message+'\n\nAssicurati che api.php sia nella stessa cartella.');}}

async function saveSnap(){
const nome=prompt('Nome snapshot:','v'+new Date().toLocaleDateString('it'));
if(!nome)return;
try{const r=await fetch('api.php?action=snapshot_save',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({nome})});
const d=await r.json();alert(d.ok?'✅ Snapshot: '+nome:'❌ Errore');}catch(e){alert('API non disponibile');}}

async function loadSnap(){
try{const r=await fetch('api.php?action=snapshot_list');const list=await r.json();
if(!list.length){alert('Nessuno snapshot');return;}
const msg=list.map((s,i)=>(i+1)+'. '+s.nome+' ('+s.created_at+')').join('\n');
const n=prompt('Carica snapshot:\n'+msg,'1');if(!n)return;
const id=list[parseInt(n)-1]?.id;if(!id)return;
await fetch('api.php?action=snapshot_load&id='+id);location.reload();
}catch(e){alert('API non disponibile');}}

window.initMap=initMap;
</script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBs_NQi-rFZD_3SAe4NgFa2fU6N-SXgcJU&callback=initMap" async defer></script>
</body>
</html>