<?php
require_once 'config.php';
header('Content-Type: application/json; charset=utf-8');

$action = $_GET['action'] ?? $_POST['action'] ?? '';
$db = getDB();

try {
switch ($action) {

    case 'waypoints':
        $rows = $db->query("SELECT * FROM ot_waypoints ORDER BY idx")->fetchAll();
        echo json_encode($rows);
        break;

    case 'obstacles':
        $rows = $db->query("SELECT * FROM ot_obstacles ORDER BY km")->fetchAll();
        echo json_encode($rows);
        break;

    case 'trincee':
        $rows = $db->query("SELECT * FROM ot_trincee ORDER BY start_km")->fetchAll();
        echo json_encode($rows);
        break;

    case 'settings':
        $rows = $db->query("SELECT * FROM ot_settings")->fetchAll();
        $out = [];
        foreach ($rows as $r) $out[$r['key']] = $r['value'];
        echo json_encode($out);
        break;

    case 'update_wp':
        $data = json_decode(file_get_contents('php://input'), true);
        $stmt = $db->prepare("UPDATE ot_waypoints SET lat=?,lon=?,elev_google=?,tipo=?,note=?,modified=1 WHERE id=?");
        $stmt->execute([$data['lat'],$data['lon'],$data['elev_google'],$data['tipo']??'condotta',$data['note']??'',$data['id']]);
        echo json_encode(['ok'=>true]);
        break;

    case 'add_wp':
        $data = json_decode(file_get_contents('php://input'), true);
        $stmt = $db->prepare("INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,km,tipo,note,modified) VALUES (?,?,?,0,?,?,?,?,1)");
        $stmt->execute([$data['idx'],$data['lat'],$data['lon'],$data['elev_google']??0,$data['km']??0,$data['tipo']??'condotta',$data['note']??'']);
        echo json_encode(['ok'=>true,'id'=>$db->lastInsertId()]);
        break;

    case 'delete_wp':
        $db->prepare("DELETE FROM ot_waypoints WHERE id=?")->execute([$_GET['id']??0]);
        echo json_encode(['ok'=>true]);
        break;

    case 'recalc':
        $perdita = floatval($db->query("SELECT `value` FROM ot_settings WHERE `key`='perdita_km'")->fetchColumn() ?: 0.28);
        $qstart = floatval($db->query("SELECT `value` FROM ot_settings WHERE `key`='quota_partenza'")->fetchColumn() ?: 340);
        $rows = $db->query("SELECT * FROM ot_waypoints ORDER BY idx")->fetchAll();
        $piez = $qstart;
        $stmt = $db->prepare("UPDATE ot_waypoints SET piez=?,margine=?,pressione_bar=?,classe_pn=? WHERE id=?");
        foreach ($rows as $i => $r) {
            if ($i > 0) $piez -= ($r['km'] - $rows[$i-1]['km']) * $perdita;
            $ge = $r['elev_google'] ?: 0;
            $mg = $piez - $ge;
            $bar = $mg > 0 ? $mg / 10.2 : 0;
            $pn = $bar > 25 ? 'PN40' : ($bar > 16 ? 'PN25' : 'PN16');
            $stmt->execute([$piez, $mg, $bar, $pn, $r['id']]);
        }
        echo json_encode(['ok'=>true,'piez_arrivo'=>$piez]);
        break;

    case 'save_settings':
        $data = json_decode(file_get_contents('php://input'), true);
        $stmt = $db->prepare("INSERT INTO ot_settings (`key`,`value`) VALUES (?,?) ON DUPLICATE KEY UPDATE `value`=?");
        foreach ($data as $k => $v) $stmt->execute([$k, $v, $v]);
        echo json_encode(['ok'=>true]);
        break;

    case 'snapshot_save':
        $data = json_decode(file_get_contents('php://input'), true);
        $rows = $db->query("SELECT * FROM ot_waypoints ORDER BY idx")->fetchAll();
        $stmt = $db->prepare("INSERT INTO ot_snapshots (nome,data_json,note) VALUES (?,?,?)");
        $stmt->execute([$data['nome']??'Snapshot '.date('Y-m-d H:i'), json_encode($rows), $data['note']??'']);
        echo json_encode(['ok'=>true,'id'=>$db->lastInsertId()]);
        break;

    case 'snapshot_list':
        $rows = $db->query("SELECT id,nome,note,created_at FROM ot_snapshots ORDER BY id DESC")->fetchAll();
        echo json_encode($rows);
        break;

    case 'snapshot_load':
        $row = $db->prepare("SELECT data_json FROM ot_snapshots WHERE id=?");
        $row->execute([$_GET['id']??0]);
        $data = json_decode($row->fetchColumn(), true);
        if ($data) {
            $db->exec("TRUNCATE TABLE ot_waypoints");
            $stmt = $db->prepare("INSERT INTO ot_waypoints (idx,lat,lon,elev_kml,elev_google,resolution,km,piez,margine,pressione_bar,classe_pn,tipo,note,modified) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            foreach ($data as $r) {
                $stmt->execute([$r['idx'],$r['lat'],$r['lon'],$r['elev_kml'],$r['elev_google'],$r['resolution'],$r['km'],$r['piez'],$r['margine'],$r['pressione_bar'],$r['classe_pn'],$r['tipo'],$r['note'],$r['modified']]);
            }
            echo json_encode(['ok'=>true,'count'=>count($data)]);
        } else {
            echo json_encode(['ok'=>false,'error'=>'Snapshot non trovato']);
        }
        break;

    case 'export_kml':
        $rows = $db->query("SELECT * FROM ot_waypoints ORDER BY idx")->fetchAll();
        header('Content-Type: application/vnd.google-earth.kml+xml');
        header('Content-Disposition: attachment; filename="GAA_v10_OptiTrace.kml"');
        echo '<' . '?xml version="1.0" encoding="UTF-8"?' . '>';
        echo '<kml xmlns="http://www.opengis.net/kml/2.2"><Document><name>GAA v10.0 OptiTrace</name>';
        echo '<Style id="s"><LineStyle><color>ffe95a0e</color><width>3</width></LineStyle></Style>';
        echo '<Placemark><name>Tracciato GAA</name><styleUrl>#s</styleUrl><LineString><tessellate>1</tessellate><coordinates>';
        foreach ($rows as $r) echo $r['lon'].','.$r['lat'].','.$r['elev_google'].' ';
        echo '</coordinates></LineString></Placemark>';
        // Torrini/partitori come placemark
        foreach ($rows as $r) {
            if (in_array($r['tipo'], ['partitore','torrino','prv','turbina','presa','arrivo'])) {
                echo '<Placemark><name>'.htmlspecialchars($r['tipo'].' km'.round($r['km'],1)).'</name>';
                echo '<Point><coordinates>'.$r['lon'].','.$r['lat'].','.$r['elev_google'].'</coordinates></Point></Placemark>';
            }
        }
        echo '</Document></kml>';
        exit;

    default:
        echo json_encode(['error'=>'Azione sconosciuta','actions'=>'waypoints,obstacles,trincee,settings,update_wp,add_wp,delete_wp,recalc,save_settings,snapshot_save,snapshot_list,snapshot_load,export_kml']);
}
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>
